/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui.preview;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldBlockCapture {
    private final World world;
    private final Map<BlockPos, BlockPos> blocks = Maps.newHashMap();

    public WorldBlockCapture(World world) {
        this.world = world;
    }

    public void putBlock(BlockPos capturePos, BlockPos worldPos) {
        this.blocks.put(capturePos, worldPos);
    }

    public IBlockState getBlockState(BlockPos pos) {
        BlockPos worldPos = this.blocks.get(pos);
        return worldPos == null ? Blocks.field_150350_a.func_176223_P() : this.world.func_180495_p(worldPos);
    }

    public TileEntity getBlockEntity(BlockPos pos) {
        BlockPos worldPos = this.blocks.get(pos);
        return worldPos == null ? null : this.world.func_175625_s(worldPos);
    }

    public Iterable<BlockPos> getBlockLocations() {
        return this.blocks.values();
    }

    public AxisAlignedBB getBounds() {
        if (this.blocks.isEmpty()) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        AxisAlignedBB bounds = new AxisAlignedBB((BlockPos)this.blocks.keySet().stream().findFirst().get());
        for (BlockPos pos : this.blocks.keySet()) {
            bounds = bounds.func_111270_a(new AxisAlignedBB(pos));
        }
        return bounds;
    }

    @Deprecated
    public World getWorld() {
        return this.world;
    }
}

