/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.packets;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class PacketSyncElevatorMovement
implements BasePacket {
    private int x;
    private int z;
    private EnumFacing facing;
    private double currentY;
    private double speed;

    public PacketSyncElevatorMovement(int x, int z, EnumFacing facing, double currentY, double speed) {
        this.x = x;
        this.z = z;
        this.facing = facing;
        this.currentY = currentY;
        this.speed = speed;
    }

    public PacketSyncElevatorMovement() {
    }

    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.z);
        buffer.writeInt(this.facing.func_176736_b());
        buffer.writeDouble(this.currentY);
        buffer.writeDouble(this.speed);
    }

    public void read(PacketBuffer buffer) {
        this.x = buffer.readInt();
        this.z = buffer.readInt();
        this.facing = EnumFacing.func_176731_b((int)buffer.readInt());
        this.currentY = buffer.readDouble();
        this.speed = buffer.readDouble();
    }

    public void handle(PacketContext context) {
        World world = ClientUtils.getWorld();
        if (world == null) {
            return;
        }
        ElevatorGroupCapability groups = (ElevatorGroupCapability)world.getCapability(ElevatorGroupCapability.CAPABILITY, null);
        if (groups == null) {
            return;
        }
        ElevatorGroup group = groups.get(this.x, this.z, this.facing);
        if (group == null) {
            return;
        }
        group.updateCurrentY(this.currentY, this.speed);
    }
}

