/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.crossmod.CrossModBase;
import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.MultiblockReactor;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPartBase;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbinePartBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CrossBigReactors
extends CrossModBase {
    @Override
    public int getReactorHeat(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            MultiblockReactor reactor;
            TileEntity te = world.func_175625_s(pos.func_177972_a(dir));
            if (!(te instanceof TileEntityReactorPartBase) || (reactor = ((TileEntityReactorPartBase)te).getReactorController()) == null) continue;
            return (int)reactor.getReactorHeat();
        }
        return -1;
    }

    @Override
    public List<IFluidTank> getAllTanks(TileEntity te) {
        if (te instanceof TileEntityReactorPartBase) {
            MultiblockReactor reactor = ((TileEntityReactorPartBase)te).getReactorController();
            if (reactor == null) {
                return null;
            }
            if (reactor.isPassivelyCooled()) {
                return null;
            }
            FluidTankInfo[] info = reactor.getCoolantContainer().getTankInfo(-1);
            ArrayList<IFluidTank> result = new ArrayList<IFluidTank>();
            for (FluidTankInfo tank : info) {
                result.add((IFluidTank)new FluidTank(tank.fluid, tank.capacity));
            }
            return result;
        }
        if (te instanceof TileEntityTurbinePartBase) {
            MultiblockTurbine turbine = ((TileEntityTurbinePartBase)te).getTurbine();
            if (turbine == null) {
                return null;
            }
            IFluidHandler input = turbine.getFluidHandler(IInputOutputPort.Direction.Input);
            IFluidHandler output = turbine.getFluidHandler(IInputOutputPort.Direction.Output);
            ArrayList<IFluidTank> result = new ArrayList<IFluidTank>();
            result.add((IFluidTank)new FluidTank(input.getTankProperties()[0].getContents(), input.getTankProperties()[0].getCapacity()));
            result.add((IFluidTank)new FluidTank(output.getTankProperties()[0].getContents(), output.getTankProperties()[0].getCapacity()));
            return result;
        }
        return null;
    }
}

