/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import cofh.core.block.TileNameable;
import cofh.core.block.TilePowered;
import cofh.core.fluid.FluidTankCore;
import cofh.redstoneflux.api.IEnergyStorage;
import cofh.thermalexpansion.block.device.TileFluidBuffer;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.block.dynamo.TileDynamoCompression;
import cofh.thermalexpansion.block.dynamo.TileDynamoMagmatic;
import cofh.thermalexpansion.block.machine.TileBrewer;
import cofh.thermalexpansion.block.machine.TileRefinery;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.init.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.IFluidTank;

public class CrossThermalExpansion
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof TilePowered) {
            NBTTagCompound tag = new NBTTagCompound();
            IEnergyStorage storage = ((TilePowered)te).getEnergyStorage();
            if (storage != null) {
                tag.func_74768_a("type", 13);
                tag.func_74780_a("storage", (double)storage.getEnergyStored());
                tag.func_74780_a("maxStorage", (double)storage.getMaxEnergyStored());
                return tag;
            }
        }
        return null;
    }

    @Override
    public ItemStack getGeneratorCard(TileEntity te) {
        if (te instanceof TileDynamoBase) {
            ItemStack card = new ItemStack(ModItems.itemCard, 1, 4);
            ItemStackHelper.setCoordinates(card, te.func_174877_v());
            return card;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public NBTTagCompound getGeneratorData(TileEntity te) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("euType", "RF");
            if (te instanceof TileDynamoBase) {
                tag.func_74768_a("type", 1);
                IEnergyStorage storage = ((TileDynamoBase)te).getEnergyStorage();
                tag.func_74780_a("storage", (double)storage.getEnergyStored());
                tag.func_74780_a("maxStorage", (double)storage.getMaxEnergyStored());
                int production = ((TileDynamoBase)te).getInfoEnergyPerTick();
                tag.func_74757_a("active", ((TileDynamoBase)te).isActive);
                tag.func_74780_a("production", (double)production);
                return tag;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public List<IFluidTank> getAllTanks(TileEntity te) {
        FluidTankCore tank;
        FluidTankCore tank1;
        FluidTankCore tank0;
        ArrayList<IFluidTank> result = new ArrayList<IFluidTank>();
        if (te instanceof TileDynamoCompression) {
            tank0 = ((TileDynamoCompression)te).getTank(0);
            tank1 = ((TileDynamoCompression)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add((IFluidTank)tank0);
                result.add((IFluidTank)tank1);
                return result;
            }
        }
        if (te instanceof TileDynamoMagmatic) {
            tank0 = ((TileDynamoMagmatic)te).getTank(0);
            tank1 = ((TileDynamoMagmatic)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add((IFluidTank)tank0);
                result.add((IFluidTank)tank1);
                return result;
            }
        }
        if (te instanceof TileRefinery) {
            tank0 = ((TileRefinery)te).getTank(0);
            tank1 = ((TileRefinery)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add((IFluidTank)tank0);
                result.add((IFluidTank)tank1);
                return result;
            }
        }
        if (te instanceof TileBrewer) {
            tank0 = ((TileBrewer)te).getTank(0);
            tank1 = ((TileBrewer)te).getTank(1);
            if (tank0 != null && tank1 != null) {
                result.add((IFluidTank)tank0);
                result.add((IFluidTank)tank1);
                return result;
            }
        }
        if (te instanceof TileFluidBuffer) {
            tank0 = ((TileFluidBuffer)te).getTank(0);
            tank1 = ((TileFluidBuffer)te).getTank(1);
            FluidTankCore tank2 = ((TileFluidBuffer)te).getTank(2);
            if (tank0 != null && tank1 != null && tank2 != null) {
                result.add((IFluidTank)tank0);
                result.add((IFluidTank)tank1);
                result.add((IFluidTank)tank2);
                return result;
            }
        }
        if (te instanceof TileNameable && (tank = ((TileNameable)te).getTank()) != null) {
            result.add((IFluidTank)tank);
            return result;
        }
        if (te instanceof TileDynamoBase && (tank = ((TileDynamoBase)te).getTank(0)) != null) {
            result.add((IFluidTank)tank);
            return result;
        }
        return null;
    }
}

