/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.containers.ContainerAdvancedInfoPanel;
import com.zuxelus.energycontrol.gui.GuiInfoPanel;
import com.zuxelus.energycontrol.gui.GuiPanelSlope;
import com.zuxelus.energycontrol.gui.controls.GuiInfoPanelCheckBox;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityAdvancedInfoPanel;
import com.zuxelus.zlib.gui.controls.GuiButtonGeneral;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAdvancedInfoPanel
extends GuiInfoPanel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol", "textures/gui/gui_advanced_info_panel.png");

    public GuiAdvancedInfoPanel(ContainerAdvancedInfoPanel container) {
        super(container, "tile.info_panel_advanced.name", TEXTURE);
        this.field_147000_g = 223;
    }

    @Override
    protected void initControls() {
        ItemStack stack = (ItemStack)this.panel.getCards().get((int)this.activeTab);
        this.field_146292_n.clear();
        this.func_189646_b(new GuiButtonGeneral(1, this.field_147003_i + 83, this.field_147009_r + 42, 16, 16, TEXTURE, 176, this.panel.getShowLabels() ? 15 : 31).setGradient());
        this.func_189646_b(new GuiButtonGeneral(2, this.field_147003_i + 83 + 17, this.field_147009_r + 42, 16, 16, TEXTURE, 192, 15).setGradient());
        this.func_189646_b(new GuiButtonGeneral(3, this.field_147003_i + 83 + 34, this.field_147009_r + 42, 16, 16, TEXTURE, 192, 28).setGradient().setScale(2));
        this.func_189646_b(new GuiButtonGeneral(4, this.field_147003_i + 83 + 51, this.field_147009_r + 42, 16, 16, TEXTURE, 176, this.getIconPowerTopOffset(((TileEntityAdvancedInfoPanel)this.panel).getPowerMode())).setGradient());
        this.func_189646_b(new GuiButtonGeneral(6, this.field_147003_i + 83 + 68, this.field_147009_r + 42 + 17, 16, 16, Integer.toString(this.panel.getTickRate())).setGradient());
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCardMain) {
            int slot = this.panel.getCardSlot(stack);
            if (stack.func_77952_i() == 18) {
                this.func_189646_b(new GuiButtonGeneral(5, this.field_147003_i + 83 + 68, this.field_147009_r + 42, 16, 16, "txt").setGradient());
            }
            List<PanelSetting> settingsList = ItemCardMain.getSettingsList(stack);
            int hy = this.field_146289_q.field_78288_b + 1;
            int y = 1;
            int x = this.field_147003_i + 24;
            if (settingsList != null) {
                for (PanelSetting panelSetting : settingsList) {
                    this.func_189646_b(new GuiInfoPanelCheckBox(0, x + 4, this.field_147009_r + 51 + hy * y, panelSetting, this.panel, slot, this.field_146289_q));
                    ++y;
                }
            }
            if (!this.modified) {
                this.textboxTitle = new GuiTextField(0, this.field_146289_q, 7, 16, 162, 18);
                this.textboxTitle.func_146195_b(true);
                this.textboxTitle.func_146180_a(new ItemCardReader(stack).getTitle());
            }
        } else {
            this.modified = false;
            this.textboxTitle = null;
        }
    }

    private int getIconPowerTopOffset(byte mode) {
        switch (mode) {
            case 0: {
                return 47;
            }
            case 1: {
                return 63;
            }
            case 2: {
                return 79;
            }
            case 3: {
                return 95;
            }
        }
        return 47;
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.func_73729_b(this.field_147003_i + 24, this.field_147009_r + 62 + this.activeTab * 14, 182, 0, 1, 15);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseX >= this.field_147003_i + 7 && mouseX <= this.field_147003_i + 24 && mouseY >= this.field_147009_r + 62 && mouseY <= this.field_147009_r + 104) {
            byte newTab = (byte)((mouseY - this.field_147009_r - 62) / 14);
            if (newTab > 2) {
                newTab = 2;
            }
            if (newTab != this.activeTab && this.modified) {
                this.updateTitle();
                this.modified = false;
            }
            if (this.activeTab != newTab) {
                this.activeTab = newTab;
                this.initControls();
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 4: {
                byte mode = ((TileEntityAdvancedInfoPanel)this.panel).getNextPowerMode();
                ((GuiButtonGeneral)button).setTextureTop(this.getIconPowerTopOffset(mode));
                NetworkHelper.updateSeverTileEntity(this.panel.func_174877_v(), 11, mode);
                ((TileEntityAdvancedInfoPanel)this.panel).powerMode = mode;
                return;
            }
            case 2: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiPanelSlope(this, (TileEntityAdvancedInfoPanel)this.panel));
                return;
            }
        }
        super.func_146284_a(button);
    }
}

