/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.gui.GuiInfoPanel;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import com.zuxelus.zlib.gui.GuiBase;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiHorizontalSlider
extends GuiBase {
    private GuiInfoPanel parentGui;
    private TileEntityInfoPanel panel;
    private HorizontalSlider slider;

    public GuiHorizontalSlider(GuiInfoPanel parentGui, TileEntityInfoPanel panel) {
        super("msg.ec.PanelRefreshRate", 152, 64, "energycontrol:textures/gui/gui_horizontal_slider.png");
        this.parentGui = parentGui;
        this.panel = panel;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.slider = new HorizontalSlider(1, this.guiLeft + 12, this.guiTop + 33);
        this.func_189646_b(this.slider);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.name, (this.xSize - this.field_146289_q.func_78256_a(this.name)) / 2, 6, 0x404040);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)this.parentGui);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public class HorizontalSlider
    extends GuiButton {
        public int sliderValue;
        public boolean dragging;
        private int minValue;
        private int maxValue;

        public HorizontalSlider(int id, int x, int y) {
            super(id, x, y, 132, 16, I18n.func_135052_a((String)"msg.ec.Ticks", (Object[])new Object[]{Integer.toString(GuiHorizontalSlider.this.panel.getTickRate())}));
            this.minValue = 1;
            this.maxValue = 128;
            this.dragging = false;
            this.sliderValue = GuiHorizontalSlider.this.panel.getTickRate();
        }

        private void setSliderPos(int targetX) {
            this.sliderValue = targetX - this.field_146128_h + 2;
            if (this.sliderValue < this.minValue) {
                this.sliderValue = this.minValue;
            }
            if (this.sliderValue > this.maxValue) {
                this.sliderValue = this.maxValue;
            }
            if (((GuiHorizontalSlider)GuiHorizontalSlider.this).panel.func_145831_w().field_72995_K && GuiHorizontalSlider.this.panel.getTickRate() != this.sliderValue) {
                NetworkHelper.updateSeverTileEntity(GuiHorizontalSlider.this.panel.func_174877_v(), 5, this.sliderValue);
                GuiHorizontalSlider.this.panel.setTickRate(this.sliderValue);
            }
            this.field_146126_j = I18n.func_135052_a((String)"msg.ec.Ticks", (Object[])new Object[]{Integer.toString(this.sliderValue)});
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_146125_m) {
                return;
            }
            mc.func_110434_K().func_110577_a(GuiHorizontalSlider.this.texture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.dragging) {
                this.setSliderPos(mouseX);
            }
            this.func_73729_b(this.field_146128_h - 2 + this.sliderValue, this.field_146129_i, 152, 0, 8, 16);
            GuiHorizontalSlider.this.field_146289_q.func_78276_b(this.field_146126_j, this.field_146128_h - 10 + (GuiHorizontalSlider.this.xSize - GuiHorizontalSlider.this.field_146289_q.func_78256_a(this.field_146126_j)) / 2, this.field_146129_i - 12, 0x404040);
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (!super.func_146116_c(mc, mouseX, mouseY)) {
                return false;
            }
            this.dragging = true;
            return true;
        }

        public void func_146118_a(int mouseX, int mouseY) {
            super.func_146118_a(mouseX, mouseY);
            this.dragging = false;
        }
    }
}

