/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.gui.GuiCardText;
import com.zuxelus.energycontrol.gui.GuiHorizontalSlider;
import com.zuxelus.energycontrol.gui.GuiScreenColor;
import com.zuxelus.energycontrol.gui.controls.GuiInfoPanelCheckBox;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import com.zuxelus.zlib.containers.ContainerBase;
import com.zuxelus.zlib.gui.GuiContainerBase;
import com.zuxelus.zlib.gui.controls.GuiButtonGeneral;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiInfoPanel
extends GuiContainerBase
implements IContainerListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol", "textures/gui/gui_info_panel.png");
    protected static final int ID_LABELS = 1;
    protected static final int ID_SLOPE = 2;
    protected static final int ID_COLORS = 3;
    protected static final int ID_POWER = 4;
    protected static final int ID_TEXT = 5;
    protected static final int ID_TICKRATE = 6;
    protected TileEntityInfoPanel panel;
    protected GuiTextField textboxTitle;
    protected byte activeTab;
    protected boolean modified;

    public GuiInfoPanel(ContainerBase container) {
        super(container, "tile.info_panel.name", TEXTURE);
        this.field_147000_g = 201;
        this.panel = (TileEntityInfoPanel)container.te;
        this.modified = false;
        this.activeTab = 0;
    }

    public GuiInfoPanel(ContainerBase container, String name, ResourceLocation texture) {
        super(container, name, texture);
        this.panel = (TileEntityInfoPanel)container.te;
        this.modified = false;
        this.activeTab = 0;
    }

    protected void initControls() {
        ItemStack stack = (ItemStack)this.panel.getCards().get((int)this.activeTab);
        this.field_146292_n.clear();
        this.func_189646_b(new GuiButtonGeneral(1, this.field_147003_i + this.field_146999_f - 24, this.field_147009_r + 42, 16, 16, TEXTURE, 176, this.panel.getShowLabels() ? 15 : 31).setGradient());
        if (this.panel.isColoredEval()) {
            this.func_189646_b(new GuiButtonGeneral(3, this.field_147003_i + this.field_146999_f - 24, this.field_147009_r + 42 + 17, 16, 16, TEXTURE, 192, 0).setGradient().setScale(2));
        }
        this.func_189646_b(new GuiButtonGeneral(6, this.field_147003_i + this.field_146999_f - 24, this.field_147009_r + 42 + 51, 16, 16, Integer.toString(this.panel.getTickRate())).setGradient());
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemCardMain) {
            int slot = this.panel.getCardSlot(stack);
            if (stack.func_77952_i() == 18) {
                this.func_189646_b(new GuiButtonGeneral(5, this.field_147003_i + this.field_146999_f - 24, this.field_147009_r + 42 + 34, 16, 16, "txt").setGradient());
            }
            List<PanelSetting> settingsList = ItemCardMain.getSettingsList(stack);
            int hy = this.field_146289_q.field_78288_b + 1;
            int y = 1;
            int x = this.field_147003_i + 24;
            if (settingsList != null) {
                for (PanelSetting panelSetting : settingsList) {
                    this.func_189646_b(new GuiInfoPanelCheckBox(0, x + 4, this.field_147009_r + 28 + hy * y, panelSetting, this.panel, slot, this.field_146289_q));
                    ++y;
                }
            }
            if (!this.modified) {
                this.textboxTitle = new GuiTextField(0, this.field_146289_q, 7, 16, 162, 18);
                this.textboxTitle.func_146195_b(true);
                this.textboxTitle.func_146180_a(new ItemCardReader(stack).getTitle());
            }
        } else {
            this.modified = false;
            this.textboxTitle = null;
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initControls();
        this.field_147002_h.func_82847_b((IContainerListener)this);
        this.field_147002_h.func_75132_a((IContainerListener)this);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText(this.name, this.field_146999_f, 6);
        if (this.textboxTitle != null) {
            this.textboxTitle.func_146194_f();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.textboxTitle != null) {
            boolean focused = this.textboxTitle.func_146206_l();
            this.textboxTitle.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
            if (this.textboxTitle.func_146206_l() != focused) {
                this.updateTitle();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.textboxTitle != null) {
            this.textboxTitle.func_146178_a();
        }
    }

    protected void updateTitle() {
        if (this.textboxTitle == null) {
            return;
        }
        if (this.panel.func_145831_w().field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("type", 4);
            tag.func_74768_a("slot", (int)this.activeTab);
            tag.func_74778_a("title", this.textboxTitle.func_146179_b());
            NetworkHelper.updateSeverTileEntity(this.panel.func_174877_v(), tag);
            ItemStack card = this.panel.func_70301_a(this.activeTab);
            if (!card.func_190926_b() && card.func_77973_b() instanceof ItemCardMain) {
                new ItemCardReader(card).setTitle(this.textboxTitle.func_146179_b());
            }
        }
    }

    public void func_146281_b() {
        this.updateTitle();
        super.func_146281_b();
        this.field_147002_h.func_82847_b((IContainerListener)this);
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 1: {
                boolean checked = !this.panel.getShowLabels();
                ((GuiButtonGeneral)button).setTextureTop(checked ? 15 : 31);
                NetworkHelper.updateSeverTileEntity(this.panel.func_174877_v(), 3, checked ? 1 : 0);
                this.panel.setShowLabels(checked);
                break;
            }
            case 3: {
                GuiScreenColor colorGui = new GuiScreenColor(this, this.panel);
                this.field_146297_k.func_147108_a((GuiScreen)colorGui);
                break;
            }
            case 5: {
                this.openTextGui();
                break;
            }
            case 6: {
                GuiHorizontalSlider slider = new GuiHorizontalSlider(this, this.panel);
                this.field_146297_k.func_147108_a((GuiScreen)slider);
            }
        }
    }

    protected void openTextGui() {
        ItemStack card = (ItemStack)this.panel.getCards().get((int)this.activeTab);
        if (!card.func_190926_b() && card.func_77973_b() instanceof ItemCardMain && card.func_77952_i() == 18) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiCardText(card, this.panel, this, this.activeTab));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.textboxTitle != null && this.textboxTitle.func_146206_l()) {
            if (keyCode == 1) {
                this.field_146297_k.field_71439_g.func_71053_j();
            } else if (typedChar == '\r') {
                this.updateTitle();
            } else {
                this.modified = true;
                this.textboxTitle.func_146201_a(typedChar, keyCode);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_71110_a(Container container, NonNullList<ItemStack> itemsList) {
        this.func_71111_a(container, 0, container.func_75139_a(0).func_75211_c());
    }

    public void func_71111_a(Container container, int slotInd, ItemStack stack) {
        this.initControls();
    }

    public void func_71112_a(Container container, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container container, IInventory inventory) {
    }
}

