/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.gui.controls.CompactButton;
import com.zuxelus.energycontrol.gui.controls.GuiThermoInvertRedstone;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityThermo;
import com.zuxelus.zlib.gui.GuiBase;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiThermalMonitor
extends GuiBase {
    private TileEntityThermo thermo;
    private GuiTextField textboxHeat = null;

    public GuiThermalMonitor(TileEntityThermo thermo) {
        super("tile.thermal_monitor.name", 191, 64, "energycontrol:textures/gui/gui_thermal_monitor.png");
        this.thermo = thermo;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.func_189646_b(new CompactButton(0, this.guiLeft + 47, this.guiTop + 20, 22, 12, "-1"));
        this.func_189646_b(new CompactButton(1, this.guiLeft + 47, this.guiTop + 31, 22, 12, "-10"));
        this.func_189646_b(new CompactButton(2, this.guiLeft + 12, this.guiTop + 20, 36, 12, "-100"));
        this.func_189646_b(new CompactButton(3, this.guiLeft + 12, this.guiTop + 31, 36, 12, "-1000"));
        this.func_189646_b(new CompactButton(4, this.guiLeft + 12, this.guiTop + 42, 57, 12, "-10000"));
        this.func_189646_b(new CompactButton(5, this.guiLeft + 122, this.guiTop + 20, 22, 12, "+1"));
        this.func_189646_b(new CompactButton(6, this.guiLeft + 122, this.guiTop + 31, 22, 12, "+10"));
        this.func_189646_b(new CompactButton(7, this.guiLeft + 143, this.guiTop + 20, 36, 12, "+100"));
        this.func_189646_b(new CompactButton(8, this.guiLeft + 143, this.guiTop + 31, 36, 12, "+1000"));
        this.func_189646_b(new CompactButton(9, this.guiLeft + 122, this.guiTop + 42, 57, 12, "+10000"));
        this.func_189646_b(new GuiThermoInvertRedstone(10, this.guiLeft + 70, this.guiTop + 38, this.thermo));
        this.textboxHeat = new GuiTextField(11, this.field_146289_q, 70, 21, 51, 12);
        this.textboxHeat.func_146195_b(true);
        this.textboxHeat.func_146180_a(Integer.toString(this.thermo.getHeatLevel()));
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int par1, int par2) {
        this.field_146289_q.func_78276_b(this.name, (this.xSize - this.field_146289_q.func_78256_a(this.name)) / 2, 6, 0x404040);
        if (this.textboxHeat != null) {
            this.textboxHeat.func_146194_f();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.textboxHeat != null) {
            this.textboxHeat.func_146178_a();
        }
    }

    public void func_146281_b() {
        this.updateHeat(0);
        super.func_146281_b();
    }

    private void updateHeat(int delta) {
        if (this.textboxHeat == null) {
            return;
        }
        int heat = 0;
        try {
            String value = this.textboxHeat.func_146179_b();
            if (!"".equals(value)) {
                heat = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ((heat += delta) < 0) {
            heat = 0;
        }
        if (heat >= 1000000) {
            heat = 1000000;
        }
        if (this.thermo.func_145831_w().field_72995_K && this.thermo.getHeatLevel() != heat) {
            NetworkHelper.updateSeverTileEntity(this.thermo.func_174877_v(), 1, heat);
            this.thermo.setHeatLevel(heat);
        }
        this.textboxHeat.func_146180_a(new Integer(heat).toString());
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k >= 10) {
            return;
        }
        int delta = Integer.parseInt(button.field_146126_j.replace("+", ""));
        this.updateHeat(delta);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (typedChar == '\r') {
            this.updateHeat(0);
        } else if (this.textboxHeat != null && this.textboxHeat.func_146206_l() && (Character.isDigit(typedChar) || typedChar == '\u0000' || typedChar == '\b')) {
            this.textboxHeat.func_146201_a(typedChar, keyCode);
        }
    }
}

