/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items;

import com.zuxelus.energycontrol.ClientProxy;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.ItemNanoBow;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ItemUtils;

public class ItemNanoBowTR
extends ItemNanoBow
implements IEnergyItemInfo {
    public ItemNanoBowTR() {
        this.func_77656_e(0);
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return CrossModLoader.techReborn.initCapabilities(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    @Override
    protected void discharge(ItemStack stack, double amount, EntityLivingBase player) {
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        capEnergy.extractEnergy((int)amount, false);
        ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)player);
    }

    @Override
    protected boolean canUse(ItemStack stack, double amount) {
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        return (double)capEnergy.extractEnergy((int)amount, true) >= amount;
    }

    @Override
    protected boolean isModeSwitchKeyDown(EntityPlayer player) {
        return GameSettings.func_100015_a((KeyBinding)ClientProxy.modeSwitchKey);
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxPower(ItemStack stack) {
        NBTTagCompound nbt = ItemStackHelper.getTagCompound(stack);
        if (nbt.func_74762_e("maxCharge") == 0) {
            nbt.func_74768_a("maxCharge", this.getDefaultMaxCharge());
        }
        return nbt.func_74762_e("maxCharge");
    }

    public double getMaxTransfer(ItemStack stack) {
        NBTTagCompound nbt = ItemStackHelper.getTagCompound(stack);
        if (nbt.func_74762_e("transferLimit") == 0) {
            nbt.func_74768_a("transferLimit", this.getDefaultTransferLimit());
        }
        return nbt.func_74762_e("transferLimit");
    }
}

