/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardEnergy
extends ItemCardBase {
    public ItemCardEnergy() {
        super(0, "card_energy");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        if (te == null) {
            return CardState.NO_TARGET;
        }
        NBTTagCompound tag = CrossModLoader.getEnergyData(te);
        if (tag != null && tag.func_74764_b("type")) {
            reader.setInt("type", tag.func_74762_e("type"));
            reader.setDouble("storage", tag.func_74769_h("storage"));
            reader.setDouble("maxStorage", tag.func_74769_h("maxStorage"));
            if (tag.func_74762_e("type") == 12) {
                reader.setString("euType", tag.func_74779_i("euType"));
            }
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        double energy = reader.getDouble("storage");
        double storage = reader.getDouble("maxStorage");
        String euType = "";
        switch (reader.getInt("type")) {
            case 10: {
                euType = "AE";
                break;
            }
            case 11: {
                euType = "gJ";
                break;
            }
            case 12: {
                euType = reader.getString("euType");
                break;
            }
            case 13: {
                euType = "RF";
                break;
            }
            default: {
                euType = "EU";
            }
        }
        if ((settings & 1) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelEnergy" + euType, energy, showLabels));
        }
        if ((settings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacity" + euType, storage, showLabels));
        }
        if ((settings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFree" + euType, storage - energy, showLabels));
        }
        if ((settings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelPercentage", storage == 0.0 ? 100.0 : energy / storage * 100.0, showLabels));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(4);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEnergy", (Object[])new Object[0]), 1, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelFree", (Object[])new Object[0]), 2, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelCapacity", (Object[])new Object[0]), 4, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelPercentage", (Object[])new Object[0]), 8, this.damage));
        return result;
    }

    @Override
    public int getKitFromCard() {
        return 0;
    }
}

