/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import com.zuxelus.energycontrol.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardInventory
extends ItemCardBase {
    public ItemCardInventory() {
        super(15, "card_inventory");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        if (te instanceof IInventory) {
            IInventory inv = (IInventory)te;
            reader.setString("name", inv.func_70005_c_());
            reader.setInt("size", inv.func_70302_i_());
            reader.setBoolean("sided", inv instanceof ISidedInventory);
            reader.removeField("slot0");
            reader.removeField("slot1");
            reader.removeField("slot2");
            reader.removeField("slot3");
            int inUse = 0;
            int items = 0;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) != ItemStack.field_190927_a) {
                    ++inUse;
                    items += inv.func_70301_a(i).func_190916_E();
                }
                if (i == 0) {
                    reader.setTag("slot0", (NBTBase)inv.func_70301_a(0).func_77955_b(new NBTTagCompound()));
                }
                if (i == 1) {
                    reader.setTag("slot1", (NBTBase)inv.func_70301_a(1).func_77955_b(new NBTTagCompound()));
                }
                if (i == 2) {
                    reader.setTag("slot2", (NBTBase)inv.func_70301_a(2).func_77955_b(new NBTTagCompound()));
                }
                if (i != 3) continue;
                reader.setTag("slot3", (NBTBase)inv.func_70301_a(3).func_77955_b(new NBTTagCompound()));
            }
            reader.setInt("used", inUse);
            reader.setInt("items", items);
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        if (isServer) {
            result.add(new PanelString("msg.ec.InfoPanelTotalItems", reader.getInt("items").intValue(), showLabels));
            result.add(new PanelString("msg.ec.InfoPanelSlotsUsed", String.format("%s/%s", reader.getInt("used"), reader.getInt("size")), showLabels));
        } else {
            result.add(new PanelString("msg.ec.InfoPanelName", I18n.func_135052_a((String)reader.getString("name"), (Object[])new Object[0]), showLabels));
            result.add(new PanelString("msg.ec.InfoPanelTotalItems", reader.getInt("items").intValue(), showLabels));
            result.add(new PanelString("msg.ec.InfoPanelSlotsUsed", String.format("%s/%s", reader.getInt("used"), reader.getInt("size")), showLabels));
            result.add(new PanelString("msg.ec.InfoPanelSidedInventory", reader.getBoolean("sided").toString(), showLabels));
            if (reader.hasField("slot0")) {
                result.add(new PanelString(String.format("msg.ec.InfoPanelSlot%d", 1), StringUtils.getItemName(new ItemStack(reader.getTag("slot0"))), showLabels));
            }
            if (reader.hasField("slot1")) {
                result.add(new PanelString(String.format("msg.ec.InfoPanelSlot%d", 2), StringUtils.getItemName(new ItemStack(reader.getTag("slot1"))), showLabels));
            }
            if (reader.hasField("slot2")) {
                result.add(new PanelString(String.format("msg.ec.InfoPanelSlot%d", 3), StringUtils.getItemName(new ItemStack(reader.getTag("slot2"))), showLabels));
            }
            if (reader.hasField("slot3")) {
                result.add(new PanelString(String.format("msg.ec.InfoPanelSlot%d", 4), StringUtils.getItemName(new ItemStack(reader.getTag("slot3"))), showLabels));
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        return null;
    }

    @Override
    public int getKitFromCard() {
        return 8;
    }
}

