/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.IHasBars;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardLiquid
extends ItemCardBase
implements IHasBars {
    public ItemCardLiquid() {
        super(2, "card_liquid");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        IFluidTank storage = CrossModLoader.getTankAt(world, target);
        if (storage == null) {
            return CardState.NO_TARGET;
        }
        int amount = 0;
        String name = "";
        String texture = "";
        if (storage.getFluid() != null && (amount = storage.getFluid().amount) > 0) {
            name = FluidRegistry.getFluidName((FluidStack)storage.getFluid());
            texture = storage.getFluid().getFluid().getStill().toString();
        }
        reader.setInt("capacity", storage.getCapacity());
        reader.setInt("amount", amount);
        reader.setString("name", name);
        reader.setString("texture", texture);
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        int capacity = reader.getInt("capacity");
        int amount = reader.getInt("amount");
        if ((displaySettings & 1) > 0) {
            String name = reader.getString("name");
            if (name.equals("")) {
                name = isServer ? "N/A" : I18n.func_135052_a((String)"msg.ec.None", (Object[])new Object[0]);
            }
            result.add(new PanelString("msg.ec.InfoPanelName", name, showLabels));
        }
        if ((displaySettings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelAmountmB", amount, showLabels));
        }
        if ((displaySettings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFreemB", capacity - amount, showLabels));
        }
        if ((displaySettings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacitymB", capacity, showLabels));
        }
        if ((displaySettings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelPercentage", capacity == 0 ? 100.0 : (double)(amount * 100 / capacity), showLabels));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(5);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidName", (Object[])new Object[0]), 1, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidAmount", (Object[])new Object[0]), 2, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidFree", (Object[])new Object[0]), 4, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidCapacity", (Object[])new Object[0]), 8, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidPercentage", (Object[])new Object[0]), 16, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelShowBar", (Object[])new Object[0]), 1024, this.damage));
        return result;
    }

    @Override
    public int getKitFromCard() {
        return 2;
    }

    @Override
    public void renderBars(TextureManager manager, double displayWidth, double displayHeight, ICardReader reader) {
        double x = -0.4375;
        double y = -0.4375;
        double z = 0.0;
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(reader.getString("texture"));
        if (sprite == null) {
            return;
        }
        double textureX = sprite.func_94209_e();
        double textureY = sprite.func_94206_g();
        double width = 0.875f * (float)reader.getInt("amount").intValue() / (float)reader.getInt("capacity").intValue();
        double height = 0.4375;
        GlStateManager.func_179139_a((double)(displayWidth / 0.875), (double)(displayHeight / 0.875), (double)1.0);
        manager.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179084_k();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + 0.21875 + height, z).func_187315_a(textureX + 0.0, textureY + (double)sprite.func_94210_h() - (double)sprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b(x + 0.875, y + 0.21875 + height, z).func_187315_a(textureX + (double)sprite.func_94212_f() - (double)sprite.func_94209_e(), textureY + (double)sprite.func_94210_h() - (double)sprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b(x + 0.875, y + 0.21875, z).func_187315_a(textureX + (double)sprite.func_94212_f() - (double)sprite.func_94209_e(), textureY + 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y + 0.21875, z).func_187315_a(textureX + 0.0, textureY + 0.0).func_181675_d();
        tessellator.func_78381_a();
        IHasBars.drawTransparentRect(x + 0.875 - width, y + height + 0.21875, x, y + 0.21875, -1.0E-4, -1342177280);
        GlStateManager.func_179139_a((double)(0.875 / displayWidth), (double)(0.875 / displayHeight), (double)1.0);
    }
}

