/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardLiquidAdvanced
extends ItemCardBase {
    public ItemCardLiquidAdvanced() {
        super(3, "card_liquid_advanced");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        List<IFluidTank> tanks = CrossModLoader.getAllTanks(world, target);
        if (tanks == null) {
            return CardState.NO_TARGET;
        }
        int i = 0;
        for (IFluidTank tank : tanks) {
            this.addTankInfo(reader, tank, i);
            ++i;
        }
        reader.setInt("count", i);
        return CardState.OK;
    }

    private void addTankInfo(ICardReader reader, IFluidTank tank, int i) {
        FluidStack stack = tank.getFluid();
        int amount = 0;
        String name = "";
        if (stack != null) {
            amount = stack.amount;
            if (stack.amount > 0) {
                name = FluidRegistry.getFluidName((FluidStack)stack);
            }
        }
        reader.setInt(String.format("_%damount", i), amount);
        reader.setString(String.format("_%dname", i), name);
        reader.setInt(String.format("_%dcapacity", i), tank.getCapacity());
    }

    @Override
    public List<PanelString> getStringData(int displaySettings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        int count = reader.getInt("count");
        for (int i = 0; i < count; ++i) {
            this.addTankData(result, displaySettings, reader, showLabels, i);
        }
        return result;
    }

    private void addTankData(List<PanelString> result, int displaySettings, ICardReader reader, boolean showLabels, int i) {
        if (!reader.hasField(String.format("_%dcapacity", i))) {
            return;
        }
        int capacity = reader.getInt(String.format("_%dcapacity", i));
        int amount = reader.getInt(String.format("_%damount", i));
        if ((displaySettings & 1) > 0) {
            String name = reader.getString(String.format("_%dname", i));
            if (name == "") {
                name = I18n.func_135052_a((String)"msg.ec.None", (Object[])new Object[0]);
            }
            result.add(new PanelString("msg.ec.InfoPanelName", name, showLabels));
        }
        if ((displaySettings & 2) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelAmountmB", amount, showLabels));
        }
        if ((displaySettings & 4) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelFreemB", capacity - amount, showLabels));
        }
        if ((displaySettings & 8) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelCapacitymB", capacity, showLabels));
        }
        if ((displaySettings & 0x10) > 0) {
            result.add(new PanelString("msg.ec.InfoPanelPercentage", capacity == 0 ? 100.0 : (double)(amount * 100 / capacity), showLabels));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList() {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(5);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidName", (Object[])new Object[0]), 1, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidAmount", (Object[])new Object[0]), 2, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidFree", (Object[])new Object[0]), 4, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidCapacity", (Object[])new Object[0]), 8, this.damage));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidPercentage", (Object[])new Object[0]), 16, this.damage));
        return result;
    }

    @Override
    public int getKitFromCard() {
        return 3;
    }
}

