/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.IHasBars;
import com.zuxelus.energycontrol.api.IItemCard;
import com.zuxelus.energycontrol.api.ITouchAction;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.items.ItemUpgrade;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ItemCardMain
extends Item {
    public static final int LOCATION_RANGE = 8;
    private static Map<Integer, IItemCard> cards = new HashMap<Integer, IItemCard>();

    public ItemCardMain() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.canRepair = false;
        this.func_77637_a(EnergyControl.creativeTab);
    }

    public final void registerCards() {
        ItemCardMain.register("ItemCardEnergy");
        ItemCardMain.register("ItemCardCounter");
        ItemCardMain.register("ItemCardLiquid");
        ItemCardMain.register("ItemCardGenerator");
        if (Loader.isModLoaded((String)"ic2")) {
            ItemCardMain.register("ItemCardGeneratorKinetic");
            ItemCardMain.register("ItemCardGeneratorHeat");
            ItemCardMain.register("ItemCardReactor");
            ItemCardMain.register("ItemCardReactor5x5");
        }
        ItemCardMain.register("ItemCardLiquidAdvanced");
        ItemCardMain.register("ItemCardText");
        ItemCardMain.register("ItemCardTime");
        ItemCardMain.register("ItemCardEnergyArray");
        ItemCardMain.register("ItemCardLiquidArray");
        ItemCardMain.register("ItemCardGeneratorArray");
        ItemCardMain.register("ItemCardToggle");
        ItemCardMain.register("ItemCardVanilla");
        ItemCardMain.register("ItemCardInventory");
        ItemCardMain.register("ItemCardRedstone");
        if (Loader.isModLoaded((String)"buildcraftcore")) {
            ItemCardMain.register("ItemCardEngine");
        }
        if (Loader.isModLoaded((String)"draconicevolution")) {
            ItemCardMain.register("ItemCardReactorDraconic");
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            ItemCardMain.register("ItemCardAppEng");
            ItemCardMain.register("ItemCardAppEngInv");
        }
        if (Loader.isModLoaded((String)"galacticraftcore") && Loader.isModLoaded((String)"galacticraftplanets")) {
            ItemCardMain.register("ItemCardGalacticraft");
        }
        if (Loader.isModLoaded((String)"bigreactors")) {
            ItemCardMain.register("ItemCardBigReactors");
        }
        if (Loader.isModLoaded((String)"nuclearcraft")) {
            ItemCardMain.register("ItemCardNuclearCraft");
        }
        if (Loader.isModLoaded((String)"mekanismgenerators")) {
            ItemCardMain.register("ItemCardMekanism");
        }
        if (Loader.isModLoaded((String)"thermalexpansion")) {
            ItemCardMain.register("ItemCardThermalExpansion");
        }
    }

    private static void register(String className) {
        try {
            Class<?> clz = Class.forName("com.zuxelus.energycontrol.items.cards." + className);
            if (clz == null) {
                return;
            }
            IItemCard item = (IItemCard)clz.newInstance();
            if (ItemCardMain.checkCard(item)) {
                cards.put(item.getDamage(), item);
            }
        }
        catch (Exception e) {
            EnergyControl.logger.warn(String.format("Class %s not found", className));
        }
    }

    private static boolean checkCard(IItemCard item) {
        if (!cards.containsKey(item.getDamage())) {
            return true;
        }
        if (item.getDamage() <= 49) {
            EnergyControl.logger.warn(String.format("Card %s was not registered. ID %d is already used for standard card.", item.getUnlocalizedName(), item.getDamage()));
        } else {
            EnergyControl.logger.warn(String.format("Card %s was not registered. ID %d is already used for extended card.", item.getUnlocalizedName(), item.getDamage()));
        }
        return false;
    }

    public static void registerCard(IItemCard item) {
        if (ItemCardMain.checkCard(item)) {
            if (item.getDamage() <= 49) {
                EnergyControl.logger.warn(String.format("Card %s was not registered. Card ID should be bigger than %d", item.getUnlocalizedName(), 49));
                return;
            }
            cards.put(item.getDamage(), item);
        }
    }

    public static boolean containsCard(int i) {
        return cards.containsKey(i);
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77952_i();
        if (cards.containsKey(damage)) {
            return cards.get(damage).getUnlocalizedName();
        }
        return "";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Map.Entry<Integer, IItemCard> entry : cards.entrySet()) {
            Integer key = entry.getKey();
            items.add((Object)new ItemStack((Item)this, 1, key.intValue()));
        }
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        ItemCardReader reader = new ItemCardReader(stack);
        String title = reader.getTitle();
        if (title != null && !title.isEmpty()) {
            tooltip.add(title);
        }
        switch (stack.func_77952_i()) {
            case 18: 
            case 19: {
                return;
            }
            case 10: 
            case 11: 
            case 12: {
                tooltip.add(I18n.func_135052_a((String)"msg.ec.cards", (Object[])new Object[]{reader.getCardCount()}));
                return;
            }
            case 13: {
                tooltip.add(I18n.func_135052_a((String)"msg.ec.touch_card", (Object[])new Object[0]));
            }
        }
        BlockPos target = reader.getTarget();
        if (target != null) {
            tooltip.add(String.format("x: %d, y: %d, z: %d", target.func_177958_n(), target.func_177956_o(), target.func_177952_p()));
        }
    }

    public static List<PanelString> getStringData(int settings, ItemCardReader reader, boolean isServer, boolean showLabels) {
        if (cards.containsKey(reader.getCardType())) {
            return cards.get(reader.getCardType()).getStringData(settings, reader, isServer, showLabels);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static List<PanelSetting> getSettingsList(ItemStack stack) {
        int damage = stack.func_77952_i();
        if (cards.containsKey(damage)) {
            return cards.get(damage).getSettingsList();
        }
        return null;
    }

    public static CardState updateCardNBT(World world, BlockPos pos, ICardReader reader, ItemStack upgradeStack) {
        int upgradeCountRange = 0;
        if (upgradeStack != ItemStack.field_190927_a && upgradeStack.func_77973_b() instanceof ItemUpgrade && upgradeStack.func_77952_i() == 0) {
            upgradeCountRange = upgradeStack.func_190916_E();
        }
        boolean needUpdate = true;
        int range = 8 * (int)Math.pow(2.0, Math.min(upgradeCountRange, 7));
        CardState state = CardState.INVALID_CARD;
        if (ItemCardMain.isRemoteCard(reader.getCardType())) {
            BlockPos target = reader.getTarget();
            if (target != null) {
                int dx = target.func_177958_n() - pos.func_177958_n();
                int dy = target.func_177956_o() - pos.func_177956_o();
                int dz = target.func_177952_p() - pos.func_177952_p();
                if (Math.abs(dx) > range || Math.abs(dy) > range || Math.abs(dz) > range) {
                    needUpdate = false;
                    state = CardState.OUT_OF_RANGE;
                }
            } else {
                needUpdate = false;
            }
        }
        if (needUpdate) {
            state = ItemCardMain.update(world, reader, range, pos);
        }
        reader.setState(state);
        return state;
    }

    private static CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        if (cards.containsKey(reader.getCardType())) {
            return cards.get(reader.getCardType()).update(world, reader, range, pos);
        }
        return null;
    }

    public static boolean isRemoteCard(int damage) {
        if (cards.containsKey(damage)) {
            return cards.get(damage).isRemoteCard();
        }
        return false;
    }

    public static int getKitFromCard(int damage) {
        if (cards.containsKey(damage)) {
            return cards.get(damage).getKitFromCard();
        }
        return -1;
    }

    public static void runTouchAction(TileEntityInfoPanel panel, ItemStack cardStack, ItemStack stack, int slot) {
        IItemCard card;
        if (cardStack.func_77973_b() instanceof ItemCardMain && cards.containsKey(cardStack.func_77952_i()) && (card = cards.get(cardStack.func_77952_i())) instanceof ITouchAction) {
            ItemCardReader reader = new ItemCardReader(cardStack);
            if (((ITouchAction)((Object)card)).runTouchAction(panel.func_145831_w(), reader, stack)) {
                reader.updateClient(cardStack, panel, slot);
            }
        }
    }

    public static void renderImage(TextureManager manager, double displayWidth, double displayHeight, ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemCardMain && cards.containsKey(stack.func_77952_i())) {
            IItemCard card = cards.get(stack.func_77952_i());
            if (card instanceof ITouchAction) {
                ((ITouchAction)((Object)card)).renderImage(manager, new ItemCardReader(stack));
            }
            if (card instanceof IHasBars) {
                ((IHasBars)((Object)card)).renderBars(manager, displayWidth, displayHeight, new ItemCardReader(stack));
            }
        }
    }

    public static void registerModels() {
        for (Map.Entry<Integer, IItemCard> entry : cards.entrySet()) {
            Integer key = entry.getKey();
            if (key > 49) continue;
            ModItems.registerItemModel(ModItems.itemCard, key, cards.get(key).getName());
        }
    }

    public static void registerExtendedModels() {
        for (Map.Entry<Integer, IItemCard> entry : cards.entrySet()) {
            Integer key = entry.getKey();
            if (key <= 49) continue;
            ModItems.registerExternalItemModel(ModItems.itemCard, key, cards.get(key).getName());
        }
    }
}

