/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.ItemStackHelper;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.network.ChannelHandler;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardReader
implements ICardReader {
    private ItemStack card;

    public ItemCardReader(ItemStack card) {
        if (!(card.func_77973_b() instanceof ItemCardMain)) {
            EnergyControl.logger.error("CardReader should be used for card items only.");
        }
        this.card = card;
    }

    @Override
    public BlockPos getTarget() {
        NBTTagCompound tag = this.card.func_77978_p();
        if (tag == null) {
            return null;
        }
        return new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
    }

    @Override
    public void setInt(String name, Integer value) {
        NBTTagCompound tag = ItemStackHelper.getTagCompound(this.card);
        tag.func_74768_a(name, value.intValue());
    }

    @Override
    public Integer getInt(String name) {
        NBTTagCompound tag = this.card.func_77978_p();
        if (tag == null) {
            return 0;
        }
        return tag.func_74762_e(name);
    }

    @Override
    public void setLong(String name, Long value) {
        NBTTagCompound tag = ItemStackHelper.getTagCompound(this.card);
        tag.func_74772_a(name, value.longValue());
    }

    @Override
    public Long getLong(String name) {
        NBTTagCompound tag = this.card.func_77978_p();
        if (tag == null) {
            return 0L;
        }
        return tag.func_74763_f(name);
    }

    @Override
    public void setDouble(String name, Double value) {
        NBTTagCompound tag = ItemStackHelper.getTagCompound(this.card);
        tag.func_74780_a(name, value.doubleValue());
    }

    @Override
    public Double getDouble(String name) {
        NBTTagCompound tag = this.card.func_77978_p();
        if (tag == null) {
            return 0.0;
        }
        return tag.func_74769_h(name);
    }

    @Override
    public void setString(String name, String value) {
        if (name == null) {
            return;
        }
        NBTTagCompound tag = ItemStackHelper.getTagCompound(this.card);
        tag.func_74778_a(name, value);
    }

    @Override
    public String getString(String name) {
        NBTTagCompound tag = this.card.func_77978_p();
        if (tag == null) {
            return "";
        }
        return tag.func_74779_i(name);
    }

    @Override
    public void setBoolean(String name, Boolean value) {
        NBTTagCompound tag = ItemStackHelper.getTagCompound(this.card);
        tag.func_74757_a(name, value.booleanValue());
    }

    @Override
    public Boolean getBoolean(String name) {
        NBTTagCompound tag = this.card.func_77978_p();
        if (tag == null) {
            return false;
        }
        return tag.func_74767_n(name);
    }

    @Override
    public void setTitle(String title) {
        this.setString("title", title);
    }

    @Override
    public String getTitle() {
        return this.getString("title");
    }

    @Override
    public CardState getState() {
        return CardState.fromInteger(this.getInt("state"));
    }

    @Override
    public void setState(CardState state) {
        if (state != null) {
            this.setInt("state", state.getIndex());
        } else {
            this.setInt("state", CardState.NO_TARGET.getIndex());
        }
    }

    @Override
    public boolean hasField(String field) {
        return ItemStackHelper.getTagCompound(this.card).func_74764_b(field);
    }

    @Override
    public void updateClient(ItemStack stack, TileEntity panel, int slot) {
        if (panel instanceof TileEntityInfoPanel) {
            ChannelHandler.updateClientCard(this.card, (TileEntityInfoPanel)panel, slot);
        }
    }

    @Override
    public void updateServer(ItemStack stack, TileEntity panel, int slot) {
        if (panel instanceof TileEntityInfoPanel) {
            ChannelHandler.updateServerCard(this.card, (TileEntityInfoPanel)panel, slot);
        }
    }

    @Override
    public void setTag(String name, NBTBase value) {
        NBTTagCompound tag = ItemStackHelper.getTagCompound(this.card);
        if (value == null) {
            tag.func_82580_o(name);
        } else {
            tag.func_74782_a(name, value);
        }
    }

    @Override
    public NBTTagCompound getTag(String name) {
        NBTTagCompound tag = ItemStackHelper.getTagCompound(this.card);
        return (NBTTagCompound)tag.func_74781_a(name);
    }

    @Override
    public NBTTagList getTagList(String name, int type) {
        NBTTagCompound tag = ItemStackHelper.getTagCompound(this.card);
        return tag.func_150295_c(name, type);
    }

    @Override
    public ArrayList<ItemStack> getItemStackList(boolean reset) {
        NBTTagList list = this.getTagList("Items", 10);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            ItemStack stack = new ItemStack(stackTag);
            if (reset) {
                stack.func_190920_e(1);
            }
            result.add(stack);
        }
        return result;
    }

    @Override
    public void setItemStackList(ArrayList<ItemStack> list) {
        NBTTagList values = new NBTTagList();
        for (ItemStack stack : list) {
            NBTTagCompound stackTag = new NBTTagCompound();
            stack.func_77955_b(stackTag);
            values.func_74742_a((NBTBase)stackTag);
        }
        this.setTag("Items", (NBTBase)values);
    }

    @Override
    public void removeField(String name) {
        NBTTagCompound tag = ItemStackHelper.getTagCompound(this.card);
        tag.func_82580_o(name);
    }

    @Override
    public int getCardCount() {
        return this.getInt("cardCount");
    }

    @Override
    public int getCardType() {
        return this.card.func_77952_i();
    }

    @SideOnly(value=Side.CLIENT)
    public static List<PanelString> getStateMessage(CardState state) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        PanelString line = new PanelString();
        switch (state) {
            case OUT_OF_RANGE: {
                line.textCenter = I18n.func_135052_a((String)"msg.ec.InfoPanelOutOfRange", (Object[])new Object[0]);
                break;
            }
            case INVALID_CARD: {
                line.textCenter = I18n.func_135052_a((String)"msg.ec.InfoPanelInvalidCard", (Object[])new Object[0]);
                break;
            }
            case NO_TARGET: {
                line.textCenter = I18n.func_135052_a((String)"msg.ec.InfoPanelNoTarget", (Object[])new Object[0]);
                break;
            }
            case CUSTOM_ERROR: {
                break;
            }
            case OK: {
                break;
            }
        }
        result.add(line);
        return result;
    }

    @Override
    public List<PanelString> getTitleList() {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        String title = this.getTitle();
        if (title != null && !title.isEmpty()) {
            PanelString titleString = new PanelString();
            titleString.textCenter = title;
            result.add(0, titleString);
        }
        return result;
    }

    public List<PanelString> getAllData() {
        NBTTagCompound nbt = this.card.func_77978_p();
        if (nbt == null) {
            return null;
        }
        nbt = this.card.func_77978_p().func_74737_b();
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        if (nbt.func_74764_b("title") && nbt.func_74781_a("title").func_74732_a() == 8) {
            String title = nbt.func_74779_i("title");
            if (!title.equals("")) {
                result.add(new PanelString(String.format("title : %s", title)));
            }
            nbt.func_82580_o("title");
        }
        if (nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z") && nbt.func_74781_a("x").func_74732_a() == 3 && nbt.func_74781_a("y").func_74732_a() == 3 && nbt.func_74781_a("z").func_74732_a() == 3) {
            result.add(new PanelString(String.format("xyz : %s %s %s", nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"))));
            nbt.func_82580_o("x");
            nbt.func_82580_o("y");
            nbt.func_82580_o("z");
        }
        if (nbt.func_74764_b("cardCount") && nbt.func_74781_a("cardCount").func_74732_a() == 3) {
            int count = nbt.func_74762_e("cardCount");
            result.add(new PanelString(String.format("cardCount : %s", count)));
            nbt.func_82580_o("cardCount");
            for (int i = 0; i < count; ++i) {
                String[] value = new String[]{String.format("_%dx", i), String.format("_%dy", i), String.format("_%dz", i)};
                if (!nbt.func_74764_b(value[0]) || !nbt.func_74764_b(value[1]) || !nbt.func_74764_b(value[2]) || nbt.func_74781_a(value[0]).func_74732_a() != 3 || nbt.func_74781_a(value[1]).func_74732_a() != 3 || nbt.func_74781_a(value[2]).func_74732_a() != 3) continue;
                result.add(new PanelString(String.format("_%dxyz : %s %s %s", i, nbt.func_74762_e(value[0]), nbt.func_74762_e(value[1]), nbt.func_74762_e(value[2]))));
                nbt.func_82580_o(value[0]);
                nbt.func_82580_o(value[1]);
                nbt.func_82580_o(value[2]);
            }
        }
        for (String name : nbt.func_150296_c()) {
            NBTBase tag = nbt.func_74781_a(name);
            result.add(new PanelString(String.format("%s : %s", name, tag.toString())));
        }
        return result;
    }
}

