/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import cofh.thermalexpansion.block.machine.TileMachineBase;
import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCardThermalExpansion
extends ItemCardBase {
    public ItemCardThermalExpansion() {
        super(29, "card_thermal_expansion");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        if (te instanceof TileMachineBase) {
            TileMachineBase machine = (TileMachineBase)te;
            reader.setInt("type", 1);
            reader.setBoolean("active", machine.isActive);
            reader.setInt("usage", machine.getInfoEnergyPerTick());
            reader.setString("rsmode", machine.getControl().name());
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        switch (reader.getInt("type")) {
            case 1: {
                result.add(new PanelString("msg.ec.InfoPanelPowerUsage", reader.getInt("usage").intValue(), showLabels));
                result.add(new PanelString("msg.ec.InfoPanelRedstoneMode", reader.getString("rsmode"), showLabels));
                this.addOnOff(result, isServer, reader.getBoolean("active"));
            }
        }
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList() {
        return null;
    }

    @Override
    public int getKitFromCard() {
        return 17;
    }
}

