/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.kits;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.api.IItemKit;
import com.zuxelus.energycontrol.init.ModItems;
import com.zuxelus.energycontrol.items.kits.ItemKitBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class ItemKitMain
extends Item {
    private static Map<Integer, IItemKit> kits = new HashMap<Integer, IItemKit>();

    public ItemKitMain() {
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.canRepair = false;
        this.func_77637_a(EnergyControl.creativeTab);
    }

    public final void registerKits() {
        ItemKitMain.register("ItemKitEnergy");
        ItemKitMain.register("ItemKitCounter");
        ItemKitMain.register("ItemKitLiquid");
        ItemKitMain.register("ItemKitGenerator");
        if (Loader.isModLoaded((String)"ic2")) {
            ItemKitMain.register("ItemKitReactor");
        }
        ItemKitMain.register("ItemKitLiquidAdvanced");
        ItemKitMain.register("ItemKitToggle");
        ItemKitMain.register("ItemKitVanilla");
        ItemKitMain.register("ItemKitInventory");
        ItemKitMain.register("ItemKitRedstone");
        if (Loader.isModLoaded((String)"draconicevolution")) {
            ItemKitMain.register("ItemKitDraconic");
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            ItemKitMain.register("ItemKitAppEng");
        }
        if (Loader.isModLoaded((String)"galacticraftcore") && Loader.isModLoaded((String)"galacticraftplanets")) {
            ItemKitMain.register("ItemKitGalacticraft");
        }
        if (Loader.isModLoaded((String)"bigreactors")) {
            ItemKitMain.register("ItemKitBigReactors");
        }
        if (Loader.isModLoaded((String)"nuclearcraft")) {
            ItemKitMain.register("ItemKitNuclearCraft");
        }
        if (Loader.isModLoaded((String)"mekanismgenerators")) {
            ItemKitMain.register("ItemKitMekanism");
        }
        if (Loader.isModLoaded((String)"thermalexpansion")) {
            ItemKitMain.register("ItemKitThermalExpansion");
        }
    }

    private static void register(String className) {
        try {
            Class<?> clz = Class.forName("com.zuxelus.energycontrol.items.kits." + className);
            if (clz == null) {
                return;
            }
            ItemKitBase item = (ItemKitBase)clz.newInstance();
            if (ItemKitMain.checkKit(item)) {
                kits.put(item.getDamage(), item);
            }
        }
        catch (Exception e) {
            EnergyControl.logger.warn(String.format("Class %s not found", className));
        }
    }

    private static boolean checkKit(IItemKit item) {
        if (!kits.containsKey(item.getDamage())) {
            return true;
        }
        if (item.getDamage() <= 49) {
            EnergyControl.logger.warn(String.format("Kit %s was not registered. ID %d is already used for standard kit.", item.getUnlocalizedName(), item.getDamage()));
        } else {
            EnergyControl.logger.warn(String.format("Kit %s was not registered. ID %d is already used for extended kit.", item.getUnlocalizedName(), item.getDamage()));
        }
        return false;
    }

    public static final void registerKit(IItemKit item) {
        if (ItemKitMain.checkKit(item)) {
            if (item.getDamage() <= 49) {
                EnergyControl.logger.warn(String.format("Kit %s was not registered. Kit ID should be bigger than %d", item.getUnlocalizedName(), 49));
                return;
            }
            kits.put(item.getDamage(), item);
        }
    }

    public static final boolean containsKit(int i) {
        return kits.containsKey(i);
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77952_i();
        if (kits.containsKey(damage)) {
            return kits.get(damage).getUnlocalizedName();
        }
        return "";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Map.Entry<Integer, IItemKit> entry : kits.entrySet()) {
            Integer key = entry.getKey();
            items.add((Object)new ItemStack((Item)this, 1, key.intValue()));
        }
    }

    public boolean func_77645_m() {
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player == null || world == null || !(player instanceof EntityPlayerMP)) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return EnumActionResult.PASS;
        }
        IItemKit kit = this.getItemKitBase(stack.func_77952_i());
        if (kit == null) {
            return EnumActionResult.PASS;
        }
        ItemStack card = kit.getSensorCard(stack, ModItems.itemCard, player, world, pos, side);
        if (card.func_190926_b()) {
            return EnumActionResult.PASS;
        }
        if (!(player instanceof EntityPlayerMP)) {
            return EnumActionResult.SUCCESS;
        }
        stack.func_190918_g(1);
        EntityItem dropItem = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, card);
        dropItem.func_174867_a(0);
        world.func_72838_d((Entity)dropItem);
        return EnumActionResult.SUCCESS;
    }

    public IItemKit getItemKitBase(int metadata) {
        if (kits.containsKey(metadata)) {
            return kits.get(metadata);
        }
        return null;
    }

    public static final void registerModels() {
        for (Map.Entry<Integer, IItemKit> entry : kits.entrySet()) {
            Integer key = entry.getKey();
            if (key > 49) continue;
            ModItems.registerItemModel(ModItems.itemKit, key, kits.get(key).getName());
        }
    }

    public static final void registerExtendedModels() {
        for (Map.Entry<Integer, IItemKit> entry : kits.entrySet()) {
            Integer key = entry.getKey();
            if (key <= 49) continue;
            ModItems.registerExternalItemModel(ModItems.itemKit, key, kits.get(key).getName());
        }
    }
}

