/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.renderers;

import com.zuxelus.energycontrol.renderers.CubeRenderer;
import com.zuxelus.energycontrol.renderers.RotationOffset;
import com.zuxelus.energycontrol.renderers.TileEntityInfoPanelRenderer;
import com.zuxelus.energycontrol.tileentities.Screen;
import com.zuxelus.energycontrol.tileentities.TileEntityAdvancedInfoPanelExtender;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class TEAdvancedInfoPanelExtenderRenderer
extends TileEntitySpecialRenderer<TileEntityAdvancedInfoPanelExtender> {
    private static final ResourceLocation[] TEXTUREOFF;
    private static final ResourceLocation[] TEXTUREON;
    private static final CubeRenderer[] model;

    public void render(TileEntityAdvancedInfoPanelExtender te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        EnumFacing facing = te.getFacing();
        switch (facing) {
            case UP: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
            }
        }
        int color = 6;
        if (te.getColored() && ((color = te.getColorBackground()) > 15 || color < 0)) {
            color = 6;
        }
        if (destroyStage > -1) {
            this.func_147499_a(field_178460_a[destroyStage]);
        } else if (te.getPowered()) {
            this.func_147499_a(TEXTUREON[color]);
        } else {
            this.func_147499_a(TEXTUREOFF[color]);
        }
        int textureId = te.findTexture();
        int thickness = te.getThickness();
        if (thickness < 1 || thickness > 16) {
            thickness = 16;
        }
        int rotateHor = te.getRotateHor() / 7;
        int rotateVert = te.getRotateVert() / 7;
        if (thickness == 16 && rotateHor == 0 && rotateVert == 0) {
            if (destroyStage > -1) {
                TileEntityInfoPanelRenderer.DESTROY.render(0.03125f);
            } else {
                model[textureId].render(0.03125f);
            }
        } else {
            Screen screen = te.getScreen();
            if (screen != null) {
                RotationOffset offset = new RotationOffset(thickness * 2, rotateHor, rotateVert);
                if (destroyStage > -1) {
                    new CubeRenderer(0.0f, 0.0f, 0.0f, 32, 32, 32, 32.0f, 32.0f, 0, 0, offset.addOffset(screen, te.func_174877_v(), te.getFacing(), te.getRotation())).render(0.03125f);
                } else {
                    new CubeRenderer(textureId / 4 * 32 + 64, textureId % 4 * 32 + 64, offset.addOffset(screen, te.func_174877_v(), te.getFacing(), te.getRotation())).render(0.03125f);
                }
            }
        }
        GlStateManager.func_179121_F();
    }

    static {
        int i;
        TEXTUREOFF = new ResourceLocation[16];
        TEXTUREON = new ResourceLocation[16];
        for (i = 0; i < 16; ++i) {
            TEAdvancedInfoPanelExtenderRenderer.TEXTUREOFF[i] = new ResourceLocation("energycontrol" + String.format(":textures/blocks/info_panel/off/alladv%de.png", i));
            TEAdvancedInfoPanelExtenderRenderer.TEXTUREON[i] = new ResourceLocation("energycontrol" + String.format(":textures/blocks/info_panel/on/alladv%de.png", i));
        }
        model = new CubeRenderer[16];
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                TEAdvancedInfoPanelExtenderRenderer.model[i * 4 + j] = new CubeRenderer(i * 32 + 64, j * 32 + 64);
            }
        }
    }
}

