/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.renderers;

import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.renderers.CubeRenderer;
import com.zuxelus.energycontrol.tileentities.Screen;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class TileEntityInfoPanelRenderer
extends TileEntitySpecialRenderer<TileEntityInfoPanel> {
    private static final ResourceLocation[] TEXTUREOFF;
    private static final ResourceLocation[] TEXTUREON;
    private static final CubeRenderer[] model;
    public static final CubeRenderer DESTROY;

    private static String implodeArray(String[] inputArray, String glueString) {
        String output = "";
        if (inputArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String s : inputArray) {
                if (s == null || s.isEmpty()) continue;
                sb.append(glueString);
                sb.append(s);
            }
            output = sb.toString();
            if (output.length() > 1) {
                output = output.substring(1);
            }
        }
        return output;
    }

    public void render(TileEntityInfoPanel te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        switch (te.getFacing()) {
            case UP: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
                break;
            }
            case DOWN: {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)-1.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
            }
        }
        int color = 2;
        if (te.getColored() && ((color = te.getColorBackground()) > 15 || color < 0)) {
            color = 2;
        }
        if (destroyStage > -1) {
            this.func_147499_a(field_178460_a[destroyStage]);
        } else if (te.getPowered()) {
            this.func_147499_a(TEXTUREON[color]);
        } else {
            this.func_147499_a(TEXTUREOFF[color]);
        }
        if (destroyStage > -1) {
            DESTROY.render(0.03125f);
        } else {
            model[te.findTexture()].render(0.03125f);
            if (te.getPowered()) {
                List<PanelString> joinedData = te.getPanelStringList(false, te.getShowLabels());
                this.drawText(te, joinedData);
            }
        }
        GlStateManager.func_179121_F();
    }

    private void drawText(TileEntityInfoPanel panel, List<PanelString> joinedData) {
        Screen screen = panel.getScreen();
        BlockPos pos = panel.func_174877_v();
        float displayWidth = 0.875f;
        float displayHeight = 0.875f;
        float dx = 0.0f;
        float dy = 0.0f;
        float dz = 0.0f;
        if (screen != null) {
            block0 : switch (panel.getFacing()) {
                case UP: {
                    switch (panel.getRotation()) {
                        case NORTH: {
                            dz = pos.func_177952_p() - screen.maxZ - screen.minZ + pos.func_177952_p();
                            dy = pos.func_177958_n() - screen.maxX - screen.minX + pos.func_177958_n();
                            displayWidth += (float)(screen.maxX - screen.minX);
                            displayHeight += (float)(screen.maxZ - screen.minZ);
                            break block0;
                        }
                        case SOUTH: {
                            dz = pos.func_177952_p() - screen.maxZ - screen.minZ + pos.func_177952_p();
                            dy = pos.func_177958_n() - screen.maxX - screen.minX + pos.func_177958_n();
                            displayWidth += (float)(screen.maxX - screen.minX);
                            displayHeight += (float)(screen.maxZ - screen.minZ);
                            break block0;
                        }
                        case EAST: {
                            dz = pos.func_177952_p() - screen.maxZ - screen.minZ + pos.func_177952_p();
                            dy = pos.func_177958_n() - screen.maxX - screen.minX + pos.func_177958_n();
                            displayWidth += (float)(screen.maxZ - screen.minZ);
                            displayHeight += (float)(screen.maxX - screen.minX);
                            break block0;
                        }
                        case WEST: {
                            dz = pos.func_177952_p() - screen.maxZ - screen.minZ + pos.func_177952_p();
                            dy = pos.func_177958_n() - screen.maxX - screen.minX + pos.func_177958_n();
                            displayWidth += (float)(screen.maxZ - screen.minZ);
                            displayHeight += (float)(screen.maxX - screen.minX);
                            break block0;
                        }
                        case DOWN: {
                            break block0;
                        }
                    }
                    break;
                }
                case NORTH: {
                    dz = pos.func_177956_o() - screen.maxY - screen.minY + pos.func_177956_o();
                    dy = pos.func_177958_n() - screen.maxX - screen.minX + pos.func_177958_n();
                    displayWidth += (float)(screen.maxX - screen.minX);
                    displayHeight += (float)(screen.maxY - screen.minY);
                    break;
                }
                case SOUTH: {
                    dz = -(pos.func_177956_o() - screen.maxY - screen.minY + pos.func_177956_o());
                    dy = pos.func_177958_n() - screen.maxX - screen.minX + pos.func_177958_n();
                    displayWidth += (float)(screen.maxX - screen.minX);
                    displayHeight += (float)(screen.maxY - screen.minY);
                    break;
                }
                case DOWN: {
                    break;
                }
                case WEST: {
                    dz = pos.func_177952_p() - screen.maxZ + pos.func_177952_p() - screen.minZ;
                    dy = pos.func_177956_o() - screen.maxY - screen.minY + pos.func_177956_o();
                    displayWidth += (float)(screen.maxZ - screen.minZ);
                    displayHeight += (float)(screen.maxY - screen.minY);
                    break;
                }
                case EAST: {
                    dz = pos.func_177952_p() - screen.maxZ + pos.func_177952_p() - screen.minZ;
                    dy = -(pos.func_177956_o() - screen.maxY - screen.minY + pos.func_177956_o());
                    displayWidth += (float)(screen.maxZ - screen.minZ);
                    displayHeight += (float)(screen.maxY - screen.minY);
                }
            }
        }
        GlStateManager.func_179109_b((float)(0.5f - dy / 2.0f), (float)(1.01f - dx / 2.0f), (float)(0.5f - dz / 2.0f));
        GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        switch (panel.getRotation()) {
            case UP: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case SOUTH: {
                break;
            }
            case DOWN: {
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        if (panel.isTouchCard() || panel.hasBars()) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179140_f();
            panel.renderImage(this.field_147501_a.field_147553_e, displayWidth, displayHeight);
            GlStateManager.func_179145_e();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (joinedData != null) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0E-4f);
            int colorHex = 0;
            if (panel.getColored()) {
                colorHex = panel.getColorTextHex();
            }
            TileEntityInfoPanelRenderer.renderText(joinedData, displayWidth, displayHeight, colorHex, this.func_147498_b());
        }
    }

    public static void renderText(List<PanelString> joinedData, float displayWidth, float displayHeight, int colorHex, FontRenderer fontRenderer) {
        int offsetY;
        int offsetX;
        int maxWidth = 1;
        for (PanelString panelString : joinedData) {
            String currentString = TileEntityInfoPanelRenderer.implodeArray(new String[]{panelString.textLeft, panelString.textCenter, panelString.textRight}, " ");
            maxWidth = Math.max(fontRenderer.func_78256_a(currentString), maxWidth);
        }
        int lineHeight = fontRenderer.field_78288_b + 2;
        int requiredHeight = lineHeight * joinedData.size();
        float scaleX = displayWidth / (float)(maxWidth += 4);
        float scaleY = displayHeight / (float)requiredHeight;
        float scale = Math.min(scaleX, scaleY);
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        int realHeight = (int)Math.floor(displayHeight / scale);
        int realWidth = (int)Math.floor(displayWidth / scale);
        if (scaleX < scaleY) {
            offsetX = 2;
            offsetY = (realHeight - requiredHeight) / 2;
        } else {
            offsetX = (realWidth - maxWidth) / 2 + 2;
            offsetY = 0;
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179140_f();
        int row = 0;
        for (PanelString panelString : joinedData) {
            if (panelString.textLeft != null) {
                fontRenderer.func_78276_b(panelString.textLeft, offsetX - realWidth / 2, offsetY - realHeight / 2 + row * lineHeight, panelString.colorLeft != 0 ? panelString.colorLeft : colorHex);
            }
            if (panelString.textCenter != null) {
                fontRenderer.func_78276_b(panelString.textCenter, -fontRenderer.func_78256_a(panelString.textCenter) / 2, offsetY - realHeight / 2 + row * lineHeight, panelString.colorCenter != 0 ? panelString.colorCenter : colorHex);
            }
            if (panelString.textRight != null) {
                fontRenderer.func_78276_b(panelString.textRight, realWidth / 2 - fontRenderer.func_78256_a(panelString.textRight), offsetY - realHeight / 2 + row * lineHeight, panelString.colorRight != 0 ? panelString.colorRight : colorHex);
            }
            ++row;
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        int i;
        DESTROY = new CubeRenderer(0.0f, 0.0f, 0.0f, 32, 32, 32, 32.0f, 32.0f, 0, 0);
        TEXTUREOFF = new ResourceLocation[16];
        TEXTUREON = new ResourceLocation[16];
        for (i = 0; i < 16; ++i) {
            TileEntityInfoPanelRenderer.TEXTUREOFF[i] = new ResourceLocation("energycontrol" + String.format(":textures/blocks/info_panel/off/all%d.png", i));
            TileEntityInfoPanelRenderer.TEXTUREON[i] = new ResourceLocation("energycontrol" + String.format(":textures/blocks/info_panel/on/all%d.png", i));
        }
        model = new CubeRenderer[16];
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                TileEntityInfoPanelRenderer.model[i * 4 + j] = new CubeRenderer(i * 32 + 64, j * 32 + 64);
            }
        }
    }
}

