/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.entity.ai;

import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class EntityPMalleable
extends EntityParasiteBase {
    private ArrayList<String> resistanceS = new ArrayList();
    private ArrayList<Integer> resistanceI = new ArrayList();
    protected float pointReduction = 0.1f;
    protected int pointCap = 10;
    protected int DamageTypeCap = 5;
    protected double chanceLearn = 0.5;
    protected double chanceLearnFire = 0.0;
    private int onFireA;
    private int onProj;
    protected float adaptationCap = 1.0f;
    private int stun;

    public EntityPMalleable(World worldIn) {
        super(worldIn);
    }

    @Override
    public void func_70636_d() {
        if (this.stun <= 0) {
            super.func_70636_d();
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70644_a(SRPPotions.RES_E)) {
                    this.removeAllResistance(1);
                }
                if (this.onFireA > 0) {
                    --this.onFireA;
                }
                if (this.onProj > 0) {
                    --this.onProj;
                }
            }
        } else {
            --this.stun;
            if (this.stun <= 0 && this.getParasiteStatus() == 25) {
                this.setParasiteStatus(0);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        float times;
        float bonus;
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (source == DamageSource.field_76380_i || source == DamageSource.field_76368_d) {
            return super.func_70097_a(source, amount);
        }
        if ((source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) && this.field_70146_Z.nextDouble() < this.chanceLearnFire) {
            this.onFireA = 10;
        }
        if ((bonus = (times = (float)this.hasResistance(source.func_76355_l())) * this.pointReduction * amount) != 0.0f) {
            this.particleStatus(9);
            this.particleStatus(9);
        }
        amount = Math.max(amount - bonus * this.adaptationCap, 0.0f);
        return super.func_70097_a(source, amount);
    }

    public int hasResistance(String damage) {
        if (this.func_70644_a(SRPPotions.RES_E)) {
            return 0;
        }
        if (this.checkList(damage)) {
            return 0;
        }
        if (this.DamageTypeCap <= 0) {
            return 0;
        }
        if (this.field_70146_Z.nextDouble() < this.chanceLearn) {
            this.addResistance(damage);
        }
        for (int i = 0; i < this.resistanceS.size(); ++i) {
            if (!this.resistanceS.get(i).equals(damage)) continue;
            return Math.min(this.resistanceI.get(i), this.pointCap);
        }
        return 0;
    }

    public void addResistance(String damage) {
        if (this.resistanceS.size() >= this.DamageTypeCap) {
            return;
        }
        if (this.onFireA > 0) {
            return;
        }
        boolean flag = true;
        for (int i = 0; i < this.resistanceS.size(); ++i) {
            if (!this.resistanceS.get(i).equals(damage)) continue;
            int iiii = this.resistanceI.get(i) + 1;
            this.resistanceI.set(i, iiii);
            flag = false;
            if (iiii > this.pointCap) break;
            this.particleStatus(5);
            this.particleStatus(5);
            break;
        }
        if (flag) {
            this.resistanceS.add(damage);
            this.resistanceI.add(1);
            this.particleStatus(5);
            this.particleStatus(5);
        }
    }

    public void removeAllResistance(int value) {
        for (int i = 0; i < this.resistanceS.size(); ++i) {
            int iiii = this.resistanceI.get(i) - value;
            if (iiii <= 0) {
                this.resistanceI.remove(i);
                this.resistanceS.remove(i);
                continue;
            }
            this.resistanceI.set(i, iiii);
        }
    }

    public ArrayList<String> getResistanceS() {
        return this.resistanceS;
    }

    public ArrayList<Integer> getResistanceI() {
        return this.resistanceI;
    }

    public void copyResistancesFrom(EntityPMalleable in) {
        this.resistanceS = in.getResistanceS();
        this.resistanceI = in.getResistanceI();
    }

    public void cutResistances(int in) {
        if (this.DamageTypeCap <= 0) {
            return;
        }
        this.stun += 40;
        this.setParasiteStatus(25);
        this.func_70690_d(new PotionEffect(SRPPotions.RAGE_E, 200, 1, false, false));
        SRPPotions.applyBleeding((EntityLivingBase)this, 100, 0);
        if (in % 2 != 0) {
            ++in;
        }
        this.DamageTypeCap -= in;
        if (this.resistanceI.size() != this.resistanceS.size()) {
            this.resistanceI = new ArrayList();
            this.resistanceS = new ArrayList();
            return;
        }
        int size = this.resistanceS.size() - in;
        if (size <= 0) {
            this.resistanceI = new ArrayList();
            this.resistanceS = new ArrayList();
            return;
        }
        while (in <= 0) {
            this.resistanceI.remove(0);
            this.resistanceS.remove(0);
            --in;
        }
    }

    private boolean checkList(String damage) {
        return ParasiteEventEntity.checkName(damage, SRPConfig.damageTypeBlackList, SRPConfig.damageTypeBlackListWhite);
    }

    private void underProjectile(DamageSource source) {
        if (source.func_76352_a() && this.func_70638_az() == null) {
            if (source.func_76346_g() != null) {
                double d = this.func_70068_e(source.func_76346_g()) * 0.8;
                double f = this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111125_b() * 0.8;
                if (d > (f *= f)) {
                    this.onProj += 20;
                    if (this.onProj >= 50) {
                        // empty if block
                    }
                } else if (source.func_76346_g() instanceof EntityLivingBase) {
                    this.func_70624_b((EntityLivingBase)source.func_76346_g());
                }
            } else {
                this.onProj += 20;
                if (this.onProj >= 50) {
                    // empty if block
                }
            }
        }
    }

    private void belowTarget(DamageSource source) {
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.resistanceS.size() != this.resistanceI.size()) {
            return;
        }
        NBTTagList allResS = new NBTTagList();
        NBTTagList allResI = new NBTTagList();
        for (int i = 0; i < this.resistanceS.size(); ++i) {
            String res = this.resistanceS.get(i);
            NBTTagCompound resT = new NBTTagCompound();
            resT.func_74778_a("resistance" + i, res);
            allResS.func_74742_a((NBTBase)resT);
            int resi = this.resistanceI.get(i);
            NBTTagCompound resU = new NBTTagCompound();
            resU.func_74768_a("resistance" + i, resi);
            allResI.func_74742_a((NBTBase)resU);
        }
        compound.func_74768_a("damagetypecap", this.DamageTypeCap);
        compound.func_74782_a("sprresistances", (NBTBase)allResS);
        compound.func_74782_a("sprresistancei", (NBTBase)allResI);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("damagetypecap", 99)) {
            this.DamageTypeCap = compound.func_74762_e("damagetypecap");
        }
        if (compound.func_74764_b("sprresistances")) {
            NBTTagList allResS = compound.func_150295_c("sprresistances", 10);
            NBTTagList allResI = compound.func_150295_c("sprresistancei", 10);
            if (allResS.func_74745_c() != allResI.func_74745_c()) {
                return;
            }
            for (int i = 0; i < allResS.func_74745_c(); ++i) {
                NBTTagCompound resT = allResS.func_150305_b(i);
                String res = resT.func_74779_i("resistance" + i);
                this.resistanceS.add(i, res);
                NBTTagCompound resU = allResI.func_150305_b(i);
                int resi = resU.func_74762_e("resistance" + i);
                this.resistanceI.add(i, resi);
            }
        }
    }
}

