/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.network;

import com.dhanantry.scapeandrunparasites.util.ParasiteEventWorld;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class SRPCommandColony
implements ICommand {
    private final List aliases = new ArrayList();

    public SRPCommandColony() {
        this.aliases.add("srpcolonies");
    }

    public int compareTo(ICommand arg0) {
        return 0;
    }

    public String func_71517_b() {
        return "srpcolonies";
    }

    public String func_71518_a(ICommandSender sender) {
        return "srpcolonies <text>";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] argString) throws CommandException {
        World world = sender.func_130014_f_();
        if (!world.field_72995_K) {
            int z;
            int y;
            int x;
            if (!SRPConfig.coloniesActivated) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Colonies are not activated"));
                return;
            }
            if (argString.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid argument"));
                return;
            }
            if (argString[0].equals("viewall")) {
                SRPWorldData data = SRPWorldData.get(world);
                ArrayList<Integer> coloniessX = data.getColonies("x");
                ArrayList<Integer> coloniessY = data.getColonies("y");
                ArrayList<Integer> coloniessZ = data.getColonies("z");
                ArrayList<Integer> coloniessA = data.getColonies("a");
                String out = "Current colonies in the world (x, y, z, points): ";
                for (int i = 0; i < coloniessX.size(); ++i) {
                    out = out + "[" + coloniessX.get(i) + ", " + coloniessY.get(i) + ", " + coloniessZ.get(i) + ", " + coloniessA.get(i) + "] ";
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(out));
                return;
            }
            if (argString[0].equals("clearworld")) {
                SRPWorldData data = SRPWorldData.get(world);
                data.clearColonyList();
                sender.func_145747_a((ITextComponent)new TextComponentString("There are no longer colonies in this world"));
                return;
            }
            if (argString.length != 4) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid argument"));
                return;
            }
            try {
                x = Integer.parseInt(argString[1]);
                y = Integer.parseInt(argString[2]);
                z = Integer.parseInt(argString[3]);
            }
            catch (NumberFormatException nfe) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid argument"));
                return;
            }
            if (argString[0].equals("setcolony")) {
                switch (ParasiteEventWorld.placeColonyInWorld(world, new BlockPos(x, y, z))) {
                    case 1: {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Colony placed at " + x + " " + y + " " + z));
                        break;
                    }
                    case 2: {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Colonies cannot be placed in this dimension"));
                        break;
                    }
                    case 3: {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Colonies are not activated"));
                        break;
                    }
                    case 4: {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Evolution Phase is not high enough to place a Colony"));
                        break;
                    }
                    case 5: {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Unable to find a place for the Colony "));
                        break;
                    }
                    case 6: {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Colony too close to another Colony "));
                        break;
                    }
                    case 7: {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Maximum number of Colonies reached "));
                        break;
                    }
                    default: {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Unknown - Colonies "));
                    }
                }
                return;
            }
            if (argString[0].equals("removecolony")) {
                if (ParasiteEventWorld.removeColonyInWorld(world, new BlockPos(x, y, z))) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Colony removed at " + x + " " + y + " " + z));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Colony cannot be removed at " + x + " " + y + " " + z));
                }
                return;
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        ArrayList<String> atm = new ArrayList<String>();
        if (args.length == 1) {
            atm.add("viewall");
            atm.add("clearworld");
            atm.add("setcolony");
            atm.add("removecolony");
        }
        if ((args[0].equals("setcolony") || args[0].equals("removecolony")) && args.length == 2) {
            atm.add("" + sender.func_180425_c().func_177958_n());
        }
        if (args.length == 3) {
            atm.add("" + sender.func_180425_c().func_177956_o());
        }
        if (args.length == 4) {
            atm.add("" + sender.func_180425_c().func_177952_p());
        }
        return atm;
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }
}

