/*
 * Decompiled with CFR 0.152.
 */
package com.dhanantry.scapeandrunparasites.util;

import com.dhanantry.scapeandrunparasites.SRPMain;
import com.dhanantry.scapeandrunparasites.entity.SRPAttributes;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityCanSummon;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityPInfected;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityPMalleable;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityPStationary;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityPVenkrol;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.EntityBiomass;
import com.dhanantry.scapeandrunparasites.entity.monster.ancient.EntityAncientPod;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.EntityTonro;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.EntityUnvo;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.EntityVenkrol;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityKol;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInhooM;
import com.dhanantry.scapeandrunparasites.entity.monster.infected.EntityInhooS;
import com.dhanantry.scapeandrunparasites.entity.monster.primitive.EntityCanra;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityProjectileBiomass;
import com.dhanantry.scapeandrunparasites.init.SRPBlocks;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.network.SRPPacketMovingSound;
import com.dhanantry.scapeandrunparasites.network.SRPPacketParticle;
import com.dhanantry.scapeandrunparasites.util.SRPConfig;
import com.dhanantry.scapeandrunparasites.world.SRPWorldData;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;

public class ParasiteEventEntity {
    public static boolean checkEntity(EntityLiving entity, String[] list, boolean inverted) {
        return ParasiteEventEntity.checkName(EntityList.func_191301_a((Entity)entity).toString(), list, inverted);
    }

    public static boolean checkName(String name, String[] list, boolean inverted) {
        boolean inv = false;
        if (list.length != 0) {
            if (inverted) {
                inv = true;
            }
            for (String i : list) {
                if (inverted) {
                    if (!name.contains(i)) continue;
                    return false;
                }
                if (!name.contains(i)) continue;
                return true;
            }
        }
        return inv;
    }

    public static void spawnNext(EntityParasiteBase entityin, EntityParasiteBase entityout, boolean effects, boolean thunder) {
        entityin.func_70106_y();
        entityout.func_70012_b(entityin.field_70165_t, entityin.field_70163_u, entityin.field_70161_v, entityin.field_70177_z, entityin.field_70125_A);
        entityout.func_180482_a(entityin.field_70170_p.func_175649_E(new BlockPos((Entity)entityout)), null);
        entityout.cannotDespawn(entityin.canDespawnMob());
        if (entityin.func_145818_k_()) {
            entityout.func_96094_a(entityin.func_95999_t());
            entityout.func_174805_g(entityin.func_174833_aM());
        }
        entityin.field_70170_p.func_72838_d((Entity)entityout);
        if (entityin instanceof EntityPMalleable && entityout instanceof EntityPMalleable) {
            ((EntityPMalleable)entityout).copyResistancesFrom((EntityPMalleable)entityin);
        }
        if (effects) {
            entityout.particleStatus(7);
        }
        if (thunder && SRPConfig.thunderEnable) {
            entityout.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(entityout.field_70170_p, entityout.field_70165_t, entityout.field_70163_u, entityout.field_70161_v, true));
        }
    }

    public static void spawnM(EntityParasiteBase entityin, String[] out, int particle, boolean cannotDespawn) {
        if (!entityin.field_70170_p.field_72995_K) {
            try {
                String[] entityC = new String[3];
                Random rand = new Random();
                double x = entityin.field_70165_t;
                double y = entityin.field_70163_u;
                double z = entityin.field_70161_v;
                for (int i = 0; i < out.length; ++i) {
                    if (out[i] == null) continue;
                    entityC = out[i].split(";");
                    int max = Integer.parseInt(entityC[1]);
                    int min = Integer.parseInt(entityC[2]);
                    int total = 0;
                    total = min == max ? min : rand.nextInt(max - min + 1) + min;
                    ResourceLocation entityR = new ResourceLocation(entityC[0]);
                    block6: for (int count = 0; count < total; ++count) {
                        EntityLiving entityout = (EntityLiving)EntityList.func_188429_b((ResourceLocation)entityR, (World)entityin.field_70170_p);
                        if (entityout == null) {
                            return;
                        }
                        entityout.func_70012_b(x, y + (double)(entityin.field_70131_O / 2.0f) + 0.5, z, entityin.field_70177_z, entityin.field_70125_A);
                        entityout.func_180482_a(entityin.field_70170_p.func_175649_E(new BlockPos((Entity)entityout)), (IEntityLivingData)null);
                        if (entityout instanceof EntityParasiteBase && cannotDespawn) {
                            EntityParasiteBase parasite = (EntityParasiteBase)entityout;
                            parasite.cannotDespawn(false);
                            entityin.field_70170_p.func_72838_d((Entity)parasite);
                        } else {
                            entityin.field_70170_p.func_72838_d((Entity)entityout);
                        }
                        switch (particle) {
                            case 7: {
                                continue block6;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem while spawning entity", (Throwable)e);
            }
        }
    }

    public static boolean SummonM(EntityParasiteBase entityin, String[] out, int range, @Nullable EntityLivingBase target) {
        if (!entityin.field_70170_p.field_72995_K) {
            try {
                Random rand = new Random();
                double x = entityin.field_70165_t;
                double y = entityin.field_70163_u;
                double z = entityin.field_70161_v;
                double randomx = rand.nextInt(range);
                double randomz = rand.nextInt(range);
                double negative = rand.nextInt(2);
                if (negative == 0.0) {
                    randomx *= -1.0;
                }
                if ((negative = (double)rand.nextInt(2)) == 0.0) {
                    randomz *= -1.0;
                }
                String[] entityC = new String[3];
                int index = rand.nextInt(out.length);
                int limit = 0;
                boolean flag = true;
                while (flag) {
                    if (index >= out.length) {
                        index = 0;
                        ++limit;
                    }
                    if (limit == 2) {
                        return false;
                    }
                    if (out[index] != null) {
                        entityC = out[index].split(";");
                        double chance = Double.parseDouble(entityC[1]);
                        if (rand.nextDouble() <= chance) {
                            if (entityin.field_70170_p.func_180495_p(new BlockPos(x + randomx, y, z + randomz)).func_177230_c() == Blocks.field_150350_a && entityin.field_70170_p.func_180495_p(new BlockPos(x + randomx, y - 1.0, z + randomz)).func_177230_c() != Blocks.field_150350_a) {
                                EntityLiving entityout = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(entityC[0]), (World)entityin.field_70170_p);
                                if (entityout == null) {
                                    return false;
                                }
                                entityout.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
                                entityout.func_70012_b(x + randomx, y, z + randomz, entityin.field_70177_z, entityin.field_70125_A);
                                entityout.func_180482_a(entityin.field_70170_p.func_175649_E(new BlockPos((Entity)entityout)), (IEntityLivingData)null);
                                if (entityin instanceof EntityCanSummon) {
                                    EntityCanSummon father = (EntityCanSummon)((Object)entityin);
                                    int points = Integer.parseInt(entityC[2]);
                                    if (father.getTotalParasites() - father.getActualParasites() < points) {
                                        ++index;
                                        continue;
                                    }
                                    father.setActualParasites(points);
                                    father.addID(entityout.func_145782_y(), points);
                                }
                                if (entityout instanceof EntityPVenkrol) {
                                    if (SRPConfig.rsSky && !entityout.field_70170_p.func_175678_i(new BlockPos(entityout.field_70165_t, entityout.field_70163_u + (double)entityout.func_70047_e(), entityout.field_70161_v))) {
                                        randomx = rand.nextInt(range);
                                        randomz = rand.nextInt(range);
                                        negative = rand.nextInt(2);
                                        if (negative == 0.0) {
                                            randomx *= -1.0;
                                        }
                                        if ((negative = (double)rand.nextInt(2)) != 0.0) continue;
                                        randomz *= -1.0;
                                        continue;
                                    }
                                    Block looking = entityin.field_70170_p.func_180495_p(entityout.func_180425_c().func_177977_b()).func_177230_c();
                                    if (looking == SRPBlocks.InfestedStain) {
                                        return false;
                                    }
                                    EntityVenkrol vOut = (EntityVenkrol)entityout;
                                    vOut.setRSSpawned(true);
                                    entityin.field_70170_p.func_72838_d((Entity)vOut);
                                    if (target != null) {
                                        vOut.func_70624_b(target);
                                    }
                                    flag = false;
                                    return true;
                                }
                                entityin.field_70170_p.func_72838_d((Entity)entityout);
                                if (target != null) {
                                    entityout.func_70624_b(target);
                                }
                                flag = false;
                                return true;
                            }
                            randomx = rand.nextInt(range);
                            randomz = rand.nextInt(range);
                            negative = rand.nextInt(2);
                            if (negative == 0.0) {
                                randomx *= -1.0;
                            }
                            if ((negative = (double)rand.nextInt(2)) == 0.0) {
                                randomz *= -1.0;
                            }
                        }
                    }
                    ++index;
                }
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem while spawning entity", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean SummonM(EntityParasiteBase entityin, String[] out, int range, double tx, double ty, double tz, @Nullable EntityLivingBase target) {
        if (!entityin.field_70170_p.field_72995_K) {
            try {
                Random rand = new Random();
                double x = tx;
                double y = ty;
                double z = tz;
                double randomx = rand.nextInt(range);
                double randomz = rand.nextInt(range);
                double negative = rand.nextInt(2);
                if (negative == 0.0) {
                    randomx *= -1.0;
                }
                if ((negative = (double)rand.nextInt(2)) == 0.0) {
                    randomz *= -1.0;
                }
                String[] entityC = new String[3];
                int index = rand.nextInt(out.length);
                int limit = 0;
                boolean flag = true;
                while (flag) {
                    if (index >= out.length) {
                        index = 0;
                        ++limit;
                    }
                    if (limit == 2) {
                        return false;
                    }
                    if (out[index] != null) {
                        entityC = out[index].split(";");
                        double chance = Double.parseDouble(entityC[1]);
                        if (rand.nextDouble() <= chance) {
                            if (entityin.field_70170_p.func_180495_p(new BlockPos(x + randomx, y, z + randomz)).func_177230_c() == Blocks.field_150350_a && entityin.field_70170_p.func_180495_p(new BlockPos(x + randomx, y - 1.0, z + randomz)).func_177230_c() != Blocks.field_150350_a || entityin.getParasiteType() >= 61) {
                                Block looking;
                                if (entityin.getParasiteType() >= 62) {
                                    EntityAncientPod entityout2 = new EntityAncientPod(entityin.field_70170_p);
                                    entityout2.func_70012_b(x + randomx, y, z + randomz, entityin.field_70177_z, entityin.field_70125_A);
                                    entityout2.setOwner(entityin.getParasiteType());
                                    entityin.field_70170_p.func_72838_d((Entity)entityout2);
                                    flag = false;
                                    return true;
                                }
                                EntityLiving entityout = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(entityC[0]), (World)entityin.field_70170_p);
                                if (entityout == null) {
                                    return false;
                                }
                                entityout.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
                                entityout.func_70012_b(x + randomx, y, z + randomz, entityin.field_70177_z, entityin.field_70125_A);
                                entityout.func_180482_a(entityin.field_70170_p.func_175649_E(new BlockPos((Entity)entityout)), (IEntityLivingData)null);
                                if (entityin instanceof EntityCanSummon) {
                                    EntityCanSummon father = (EntityCanSummon)((Object)entityin);
                                    int points = Integer.parseInt(entityC[2]);
                                    if (father.getTotalParasites() - father.getActualParasites() < points) {
                                        ++index;
                                        continue;
                                    }
                                    father.setActualParasites(points);
                                    father.addID(entityout.func_145782_y(), points);
                                }
                                if (entityout instanceof EntityVenkrol && (looking = entityin.field_70170_p.func_180495_p(entityout.func_180425_c().func_177977_b()).func_177230_c()) == SRPBlocks.InfestedStain) {
                                    return false;
                                }
                                entityin.field_70170_p.func_72838_d((Entity)entityout);
                                if (target != null) {
                                    entityout.func_70624_b(target);
                                }
                                flag = false;
                                if (entityout instanceof EntityParasiteBase) {
                                    EntityParasiteBase eOut = (EntityParasiteBase)entityout;
                                    eOut.setParasiteToFollow(entityin);
                                }
                                return true;
                            }
                            randomx = rand.nextInt(range);
                            randomz = rand.nextInt(range);
                            negative = rand.nextInt(2);
                            if (negative == 0.0) {
                                randomx *= -1.0;
                            }
                            if ((negative = (double)rand.nextInt(2)) == 0.0) {
                                randomz *= -1.0;
                            }
                        }
                    }
                    ++index;
                }
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem while spawning entity", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean spawnBiomassFromProjectile(EntityParasiteBase entityin, String[] out, @Nullable EntityLivingBase target) {
        if (!entityin.field_70170_p.field_72995_K) {
            try {
                Random rand = new Random();
                String[] entityC = new String[3];
                int index = rand.nextInt(out.length);
                int limit = 0;
                boolean flag = true;
                while (flag) {
                    if (index >= out.length) {
                        index = 0;
                        ++limit;
                    }
                    if (limit == 2) {
                        return false;
                    }
                    if (out[index] != null) {
                        entityC = out[index].split(";");
                        double chance = Double.parseDouble(entityC[1]);
                        if (rand.nextDouble() <= chance) {
                            EntityCanSummon father = (EntityCanSummon)((Object)entityin);
                            int points = Integer.parseInt(entityC[2]);
                            if (father.getTotalParasites() - father.getActualParasites() < points) {
                                ++index;
                                continue;
                            }
                            if (target == null) {
                                return false;
                            }
                            double d1 = 4.0;
                            Vec3d vec3d = entityin.func_70676_i(1.0f);
                            double d2 = target.field_70165_t - (entityin.field_70165_t + vec3d.field_72450_a);
                            double d3 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (0.5 + entityin.field_70163_u + (double)(entityin.field_70131_O / 2.0f));
                            double d4 = target.field_70161_v - (entityin.field_70161_v + vec3d.field_72449_c);
                            EntityProjectileBiomass entityout = new EntityProjectileBiomass(entityin.field_70170_p, (EntityLivingBase)entityin, d2, d3, d4);
                            entityout.field_70165_t = entityin.field_70165_t + vec3d.field_72450_a;
                            entityout.field_70163_u = entityin.field_70163_u + (double)entityin.func_70047_e() - 0.2;
                            entityout.field_70161_v = entityin.field_70161_v + vec3d.field_72449_c;
                            entityout.setParasite(entityC[0], points, 4);
                            father.setActualParasites(points);
                            father.addID(entityout.func_145782_y(), points);
                            entityin.field_70170_p.func_72838_d((Entity)entityout);
                            flag = false;
                            return true;
                        }
                    }
                    ++index;
                }
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem while spawning entity", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean spawnBiomassFromVomit(EntityParasiteBase entityin, String[] out, @Nullable EntityLivingBase target) {
        if (!entityin.field_70170_p.field_72995_K) {
            try {
                Random rand = new Random();
                String[] entityC = new String[3];
                int index = rand.nextInt(out.length);
                int limit = 0;
                boolean flag = true;
                while (flag) {
                    if (index >= out.length) {
                        index = 0;
                        ++limit;
                    }
                    if (limit == 2) {
                        return false;
                    }
                    if (out[index] != null) {
                        entityC = out[index].split(";");
                        double chance = Double.parseDouble(entityC[1]);
                        if (rand.nextDouble() <= chance) {
                            EntityCanSummon father = (EntityCanSummon)((Object)entityin);
                            int points = Integer.parseInt(entityC[2]);
                            if (father.getTotalParasites() - father.getActualParasites() < points) {
                                ++index;
                                continue;
                            }
                            EntityBiomass entityout = new EntityBiomass(entityin.field_70170_p, entityin, target);
                            entityout.func_70012_b(entityin.field_70165_t, entityin.field_70163_u, entityin.field_70161_v, entityin.field_70177_z, entityin.field_70125_A);
                            float f19 = MathHelper.func_76126_a((float)(entityin.field_70177_z * ((float)Math.PI / 180) - entityin.field_70704_bt * 0.01f));
                            float f14 = 0.17453292f;
                            float f16 = MathHelper.func_76134_b((float)f14);
                            float f4 = MathHelper.func_76134_b((float)(entityin.field_70177_z * ((float)Math.PI / 180) - entityin.field_70704_bt * 0.01f));
                            entityout.field_70177_z = entityin.field_70177_z;
                            entityout.func_70107_b(entityin.field_70165_t + -1.0 * (double)(f19 * 3.0f * f16), entityin.field_70163_u + (double)entityin.func_70047_e(), entityin.field_70161_v - -1.0 * (double)(f4 * 3.0f * f16));
                            entityout.setFuse(80);
                            entityout.setParasite(entityC[0], points);
                            if (entityin instanceof EntityCanra) {
                                entityout.setSkin(5);
                            } else {
                                entityout.setSkin(6);
                            }
                            father.setActualParasites(points);
                            father.addID(entityout.func_145782_y(), points);
                            entityin.field_70170_p.func_72838_d((Entity)entityout);
                            flag = false;
                            return true;
                        }
                    }
                    ++index;
                }
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem while spawning entity", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean spawnBiomassFromBeckon(EntityParasiteBase entityin, int stage, EntityLivingBase target, boolean payfather, String[] ground, String[] air) {
        if (!entityin.field_70170_p.field_72995_K) {
            try {
                String[] mobListG = ground;
                if (entityin.field_70163_u + 3.0 <= target.field_70163_u) {
                    if (stage == 1) {
                        return false;
                    }
                    mobListG = air;
                }
                Random rand = new Random();
                String[] entityC = new String[3];
                int index = rand.nextInt(mobListG.length);
                int limit = 0;
                boolean flag = true;
                while (flag) {
                    if (index >= mobListG.length) {
                        index = 0;
                        ++limit;
                    }
                    if (limit == 2) {
                        return false;
                    }
                    if (mobListG[index] != null) {
                        entityC = mobListG[index].split(";");
                        double chance = Double.parseDouble(entityC[1]);
                        if (rand.nextDouble() <= chance) {
                            EntityCanSummon father = (EntityCanSummon)((Object)entityin);
                            int points = Integer.parseInt(entityC[2]);
                            if (father.getTotalParasites() - father.getActualParasites() < points && payfather) {
                                ++index;
                                continue;
                            }
                            double b = 0.0;
                            if (stage == 3) {
                                b = 0.5;
                            }
                            EntityBiomass entityout = new EntityBiomass(entityin.field_70170_p, entityin, stage, target, payfather);
                            entityout.func_70012_b(entityin.field_70165_t, entityin.field_70163_u + ((double)entityin.func_70047_e() + b), entityin.field_70161_v, entityin.field_70177_z, entityin.field_70125_A);
                            double d0 = (float)entityin.field_70165_t + entityin.field_70170_p.field_73012_v.nextFloat();
                            double d1 = (float)entityin.field_70163_u + entityin.func_70047_e() + entityin.field_70170_p.field_73012_v.nextFloat();
                            double d2 = (float)entityin.field_70161_v + entityin.field_70170_p.field_73012_v.nextFloat();
                            double d3 = d0 - entityin.field_70165_t;
                            double d4 = d1 - entityin.field_70163_u;
                            double d5 = d2 - entityin.field_70161_v;
                            double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                            d3 /= d6;
                            d4 /= d6;
                            d5 /= d6;
                            double d7 = 0.5 / (d6 / 4.0 + 0.1);
                            d7 *= (double)(entityin.field_70170_p.field_73012_v.nextFloat() * entityin.field_70170_p.field_73012_v.nextFloat() + 1.7f);
                            double k = 3.0;
                            if (stage == 3) {
                                k = 5.0;
                            }
                            d3 = d3 * d7 * k;
                            d4 = d4 * d7 * 2.0;
                            d5 = d5 * d7 * k;
                            entityout.setMotion(d3, d4, d5, 0.4, 0.5);
                            entityout.setFuse(80);
                            entityout.setParasite(entityC[0], points);
                            entityout.setSkin(stage);
                            entityin.field_70170_p.func_72838_d((Entity)entityout);
                            if (payfather) {
                                father.setActualParasites(points);
                                father.addID(entityout.func_145782_y(), points);
                            }
                            flag = false;
                            return true;
                        }
                    }
                    ++index;
                }
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem while spawning entity", (Throwable)e);
            }
        }
        return false;
    }

    public static void spreadCOTH(EntityLivingBase target, int mazAmp) {
    }

    public static void convertEntity(EntityLivingBase entityin, NBTTagCompound tags, boolean ignoreKey, String[] list) {
        if (entityin == null) {
            return;
        }
        if (tags.func_74764_b("srpcothimmunity")) {
            int key = tags.func_74762_e("srpcothimmunity");
            if (key == 0 && !ignoreKey) {
                entityin.func_184596_c(SRPPotions.COTH_E);
                return;
            }
            entityin.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 3, false, false));
            SRPMain.network.sendToAll((IMessage)new SRPPacketParticle(entityin.func_180425_c(), entityin.field_70130_N, entityin.field_70131_O, 1));
            tags.func_74768_a("srpcothimmunity", ++key);
            if (key < 3 && !ignoreKey) {
                return;
            }
            World world = entityin.field_70170_p;
            if (world.field_72995_K) {
                return;
            }
            String mobname = null;
            try {
                mobname = EntityList.func_191301_a((Entity)entityin).toString();
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem while spawning entity", (Throwable)e);
                return;
            }
            if (mobname == null) {
                return;
            }
            String[] here = new String[2];
            boolean flag = true;
            for (int i = 0; i < list.length; ++i) {
                here = list[i].split(";");
                if (here[1] == null) {
                    ParasiteEventEntity.spawnInsider(entityin, world, tags);
                    return;
                }
                if (!here[0].equals(mobname)) continue;
                EntityPInfected entityout = (EntityPInfected)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(here[1]), (World)world);
                if (entityout == null) {
                    ParasiteEventEntity.spawnInsider(entityin, world, tags);
                    return;
                }
                entityout.func_82149_j((Entity)entityin);
                world.func_72900_e((Entity)entityin);
                entityout.setHost(mobname);
                entityout.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityout)), null);
                if (entityin.func_145818_k_()) {
                    entityout.func_96094_a(entityin.func_95999_t());
                    entityout.func_174805_g(entityin.func_174833_aM());
                }
                world.func_72838_d((Entity)entityout);
                world.func_180498_a((EntityPlayer)null, 1026, new BlockPos((Entity)entityout), 0);
                entityout.particleStatus(7);
                entityout.cannotDespawn(false);
                flag = false;
            }
            if (flag && !ignoreKey) {
                ParasiteEventEntity.spawnInsider(entityin, world, tags);
            }
        }
    }

    public static void spawnInsider(EntityLivingBase entity, World world, NBTTagCompound tags) {
        if (tags.func_74764_b("srpcothimmunity")) {
            int key = tags.func_74762_e("srpcothimmunity");
            if (key == 0) {
                entity.func_184596_c(SRPPotions.COTH_E);
                return;
            }
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 3, false, false));
            SRPMain.network.sendToAll((IMessage)new SRPPacketParticle(entity.func_180425_c(), entity.field_70130_N, entity.field_70131_O, 1));
            tags.func_74768_a("srpcothimmunity", ++key);
            if (key < 3) {
                return;
            }
            EntityPInfected out = new EntityInhooS(world);
            float mass = ParasiteEventEntity.getEntityArea(entity);
            if (!(mass > 0.11f && mass <= 0.517f || !((double)mass > 0.517))) {
                out = new EntityInhooM(world);
            }
            out.func_82149_j((Entity)entity);
            world.func_72900_e((Entity)entity);
            world.func_72838_d((Entity)out);
            world.func_180498_a((EntityPlayer)null, 1026, new BlockPos((Entity)out), 0);
            out.particleStatus(7);
            out.cannotDespawn(false);
        }
    }

    private static float getEntityArea(EntityLivingBase entity) {
        return entity.field_70130_N * entity.field_70130_N * entity.field_70131_O;
    }

    public static boolean merge(EntityParasiteBase entityin, int code) {
        if (SRPConfig.mergeRandom) {
            entityin.particleStatus(7);
            String[] entityC = new String[2];
            Random rand = new Random();
            int index = rand.nextInt(SRPConfig.mergeMobTable.length);
            boolean flag = true;
            int limit = 0;
            while (flag) {
                if (index >= SRPConfig.mergeMobTable.length) {
                    index = 0;
                    ++limit;
                }
                if (limit == 2) {
                    return false;
                }
                if (SRPConfig.mergeMobTable[index] != null) {
                    entityC = SRPConfig.mergeMobTable[index].split(";");
                    ParasiteEventEntity.spawnM(entityin, new String[]{entityC[0] + ";1;1"}, 7, true);
                    flag = false;
                    if (SRPConfig.useEvolution) {
                        SRPWorldData data = SRPWorldData.get(entityin.field_70170_p);
                        data.setTotalKills(SRPConfig.valueMerge, true, entityin.field_70170_p);
                    }
                    return true;
                }
                ++index;
            }
        } else {
            String[] entityC = new String[2];
            for (int i = 0; i < SRPConfig.mergeMobTable.length; ++i) {
                int points;
                if (SRPConfig.mergeMobTable[i] == null || (points = Integer.parseInt((entityC = SRPConfig.mergeMobTable[i].split(";"))[1])) != code) continue;
                ParasiteEventEntity.spawnM(entityin, new String[]{entityC[0] + ";1;1"}, 7, true);
                if (SRPConfig.useEvolution) {
                    SRPWorldData data = SRPWorldData.get(entityin.field_70170_p);
                    data.setTotalKills(SRPConfig.valueMerge, true, entityin.field_70170_p);
                }
                return true;
            }
            Random rand = new Random();
            int index = rand.nextInt(SRPConfig.mergeMobTable.length);
            boolean flag = true;
            int limit = 0;
            while (flag) {
                if (index >= SRPConfig.mergeMobTable.length) {
                    index = 0;
                    ++limit;
                }
                if (limit == 2) {
                    return false;
                }
                if (SRPConfig.mergeMobTable[index] != null) {
                    entityC = SRPConfig.mergeMobTable[index].split(";");
                    ParasiteEventEntity.spawnM(entityin, new String[]{entityC[0] + ";1;1"}, 7, true);
                    flag = false;
                    if (SRPConfig.useEvolution) {
                        SRPWorldData data = SRPWorldData.get(entityin.field_70170_p);
                        data.setTotalKills(SRPConfig.valueMerge, true, entityin.field_70170_p);
                    }
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    public static void damageEntity(World worldIn, BlockPos pos, Entity entityIn, int stage) {
        Random rand;
        double chance = 0.0;
        float damage = 0.0f;
        if (stage == 1 || stage == 11) {
            chance = SRPConfig.venkrolBlockChance;
            damage = SRPConfig.venkrolBlockDamage;
        } else if (stage == 2 || stage == 12) {
            chance = SRPConfig.venkrolsiiBlockChance;
            damage = SRPConfig.venkrolsiiBlockDamage;
        } else if (stage == 3 || stage == 13) {
            chance = SRPConfig.venkrolsiiiBlockChance;
            damage = SRPConfig.venkrolsiiiBlockDamage;
        }
        if (entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            try {
                double minus = ParasiteEventEntity.EquipCheck(player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b().getRegistryName().toString(), player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b().getRegistryName().toString(), player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b().getRegistryName().toString(), player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b().getRegistryName().toString());
                Random rand2 = new Random();
                if (rand2.nextDouble() <= chance) {
                    if (rand2.nextDouble() <= minus) {
                        entityIn.func_70097_a(DamageSource.field_76366_f, damage);
                        return;
                    }
                    return;
                }
                return;
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem with player walking on infested block", (Throwable)e);
            }
        }
        if ((rand = new Random()).nextDouble() <= chance) {
            entityIn.func_70097_a(DamageSource.field_76366_f, damage);
        }
    }

    private static double EquipCheck(String head, String body, String legs, String boots) {
        int i;
        double flag = 1.0;
        String[] here = new String[2];
        for (i = 0; i < SRPAttributes.headEquip.length; ++i) {
            if (SRPAttributes.headEquip[i] == null || !(here = SRPAttributes.headEquip[i].split(";"))[0].equals(head)) continue;
            flag -= Double.parseDouble(here[1]);
            break;
        }
        for (i = 0; i < SRPAttributes.bodyEquip.length; ++i) {
            if (SRPAttributes.bodyEquip[i] == null || !(here = SRPAttributes.bodyEquip[i].split(";"))[0].equals(body)) continue;
            flag -= Double.parseDouble(here[1]);
            break;
        }
        for (i = 0; i < SRPAttributes.legsEquip.length; ++i) {
            if (SRPAttributes.legsEquip[i] == null || !(here = SRPAttributes.legsEquip[i].split(";"))[0].equals(legs)) continue;
            flag -= Double.parseDouble(here[1]);
            break;
        }
        for (i = 0; i < SRPAttributes.bootsEquip.length; ++i) {
            if (SRPAttributes.bootsEquip[i] == null || !(here = SRPAttributes.bootsEquip[i].split(";"))[0].equals(boots)) continue;
            flag -= Double.parseDouble(here[1]);
            break;
        }
        return flag;
    }

    public static BlockPos getFloor(World worldIn, BlockPos pos, int loop) {
        if (loop <= 0) {
            return null;
        }
        --loop;
        if (worldIn.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150350_a) {
                return pos;
            }
            return ParasiteEventEntity.getFloor(worldIn, pos.func_177977_b(), loop);
        }
        return ParasiteEventEntity.getFloor(worldIn, pos.func_177984_a(), loop);
    }

    public static boolean spawnTurrets(EntityLivingBase entityin, int range, byte type, int stage) {
        if (stage <= 2) {
            return false;
        }
        Random rand = new Random();
        World world = entityin.field_70170_p;
        double randomx = rand.nextInt(range);
        double randomz = rand.nextInt(range);
        double negative = rand.nextInt(2);
        if (negative == 0.0) {
            randomx *= -1.0;
        }
        if ((negative = (double)rand.nextInt(2)) == 0.0) {
            randomz *= -1.0;
        }
        int index = 5;
        int limit = 0;
        boolean flag = true;
        while (flag) {
            if (limit >= 5) {
                return false;
            }
            BlockPos floor = ParasiteEventEntity.getFloor(world, new BlockPos(entityin.field_70165_t + randomx, entityin.field_70163_u, entityin.field_70161_v + randomz), 5);
            if (floor != null && world.func_180495_p(floor.func_177977_b()).func_177230_c() == SRPBlocks.InfestedStain) {
                int flag2 = 0;
                AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)floor.func_177958_n(), (double)floor.func_177956_o(), (double)floor.func_177952_p(), (double)(floor.func_177958_n() + 1), (double)(floor.func_177956_o() + 1), (double)(floor.func_177952_p() + 1)).func_72314_b(42.0, 5.0, 42.0);
                List moblist = world.func_72872_a(EntityParasiteBase.class, axisalignedbb);
                for (EntityParasiteBase mob : moblist) {
                    if (!mob.func_70089_S() || mob.getParasiteType() != 40) continue;
                    ++flag2;
                }
                if (flag2 < 3) {
                    EntityPStationary out;
                    if (type == 1) {
                        if (!SRPConfig.unvoEnabled) {
                            return false;
                        }
                        out = new EntityUnvo(world);
                        out.func_70012_b(floor.func_177958_n(), floor.func_177956_o(), floor.func_177952_p(), 0.0f, 0.0f);
                        world.func_72838_d((Entity)out);
                        out.func_70624_b(entityin);
                        return true;
                    }
                    if (type == 2) {
                        if (!SRPConfig.tonroEnabled) {
                            return false;
                        }
                        out = new EntityTonro(world);
                        out.func_70012_b(floor.func_177958_n(), floor.func_177956_o(), floor.func_177952_p(), 0.0f, 0.0f);
                        world.func_72838_d((Entity)out);
                        out.func_70624_b(entityin);
                        return true;
                    }
                } else {
                    return false;
                }
            }
            randomx = rand.nextInt(range);
            randomz = rand.nextInt(range);
            negative = rand.nextInt(2);
            if (negative == 0.0) {
                randomx *= -1.0;
            }
            if ((negative = (double)rand.nextInt(2)) == 0.0) {
                randomz *= -1.0;
            }
            ++limit;
        }
        return false;
    }

    public static void alertAllPlayerDim(World worldIn, String message, int warning) {
        List playerEntityList = worldIn.field_73010_i;
        for (int i = 0; i < playerEntityList.size(); ++i) {
            EntityPlayer theEntity = (EntityPlayer)playerEntityList.get(i);
            theEntity.func_145747_a((ITextComponent)new TextComponentString(message));
            SRPMain.network.sendToDimension((IMessage)new SRPPacketMovingSound(warning), worldIn.field_73011_w.getDimension());
        }
    }

    public static boolean spawnFromBlock(World world, String[] out, int range, BlockPos pos) {
        if (!world.field_72995_K) {
            try {
                Random rand = new Random();
                double x = pos.func_177958_n();
                double y = pos.func_177956_o();
                double z = pos.func_177952_p();
                double randomx = rand.nextInt(range);
                double randomz = rand.nextInt(range);
                double negative = rand.nextInt(2);
                if (negative == 0.0) {
                    randomx *= -1.0;
                }
                if ((negative = (double)rand.nextInt(2)) == 0.0) {
                    randomz *= -1.0;
                }
                String[] entityC = new String[3];
                int index = rand.nextInt(out.length);
                int limit = 0;
                boolean flag = true;
                while (flag) {
                    if (index >= out.length) {
                        index = 0;
                        ++limit;
                    }
                    if (limit == 2) {
                        return false;
                    }
                    if (out[index] != null) {
                        entityC = out[index].split(";");
                        double chance = Double.parseDouble(entityC[1]);
                        if (rand.nextDouble() <= chance) {
                            BlockPos helper = ParasiteEventEntity.getFloor(world, new BlockPos(x + randomx, y, z + randomz), 3);
                            if (helper != null) {
                                EntityLiving entityout = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(entityC[0]), (World)world);
                                if (entityout == null) {
                                    return false;
                                }
                                entityout.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
                                entityout.func_70012_b((double)helper.func_177958_n(), (double)helper.func_177956_o(), (double)helper.func_177952_p(), 0.0f, 0.0f);
                                entityout.func_180482_a(world.func_175649_E(helper), (IEntityLivingData)null);
                                if (entityout instanceof EntityKol) {
                                    EntityKol kol = (EntityKol)entityout;
                                    SRPWorldData data = SRPWorldData.get(world);
                                    BlockPos origin = data.nearestColonyPosition(helper, 0);
                                    if (origin != null) {
                                        kol.setTask(origin, data.getColonyDistanceSpreadByPosition(origin, false, 0));
                                    } else {
                                        return false;
                                    }
                                }
                                world.func_72838_d((Entity)entityout);
                                flag = false;
                                return true;
                            }
                            randomx = rand.nextInt(range);
                            randomz = rand.nextInt(range);
                            negative = rand.nextInt(2);
                            if (negative == 0.0) {
                                randomx *= -1.0;
                            }
                            if ((negative = (double)rand.nextInt(2)) == 0.0) {
                                randomz *= -1.0;
                            }
                        }
                    }
                    ++index;
                }
            }
            catch (Exception e) {
                SRPMain.logger.log(Level.ERROR, "Problem while spawning entity", (Throwable)e);
            }
        }
        return false;
    }
}

