/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.blocks;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import paulojjj.solarenergy.gui.GuiHandler;

public class BaseBlock
extends Block {
    private GuiHandler.GUI gui;
    private Function<Void, ? extends TileEntity> createTileEntity;
    private BiConsumer<List<ItemStack>, TileEntity> getDrops;
    private BlockRenderLayer blockRenderLayer;
    private EnumBlockRenderType blockRenderType;
    private Function<Void, BlockStateContainer> createBlockStateContainer;

    public BaseBlock() {
        super(Material.field_151576_e);
    }

    public ConfigBuilder configBuilder() {
        return new ConfigBuilderImpl();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K || this.gui == null) {
            return true;
        }
        return GuiHandler.openGui(playerIn, worldIn, this.gui, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.createTileEntity != null;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (this.createTileEntity != null) {
            TileEntity te = this.createTileEntity.apply(null);
            return te;
        }
        return super.createTileEntity(world, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (this.getDrops != null && willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        if (this.getDrops != null) {
            worldIn.func_175698_g(pos);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (this.getDrops != null) {
            TileEntity te = world.func_175625_s(pos);
            this.getDrops.accept((List<ItemStack>)drops, te);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return this.blockRenderLayer;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return this.blockRenderType;
    }

    protected BlockStateContainer func_180661_e() {
        if (this.createBlockStateContainer == null) {
            return super.func_180661_e();
        }
        return this.createBlockStateContainer.apply(null);
    }

    public class ConfigBuilderImpl
    implements ConfigBuilder {
        private BaseBlock block;
        private Map<IProperty<?>, Comparable<?>> properties;

        public ConfigBuilderImpl() {
            this.block = BaseBlock.this;
            this.properties = new LinkedHashMap();
            this.block.func_149752_b(50.0f);
            this.block.func_149711_c(3.5f);
            BaseBlock.this.blockRenderLayer = BlockRenderLayer.SOLID;
            BaseBlock.this.blockRenderType = EnumBlockRenderType.MODEL;
        }

        @Override
        public ConfigBuilder resistance(float value) {
            this.block.func_149752_b(value);
            return this;
        }

        @Override
        public ConfigBuilder hardness(float value) {
            this.block.func_149711_c(value);
            return this;
        }

        @Override
        public <T extends Comparable<T>, V extends T> ConfigBuilder with(IProperty<T> property, V value) {
            this.properties.put(property, (Comparable<?>)value);
            return this;
        }

        protected <T extends Comparable<T>, V extends T> void setProperty(IBlockState state, IProperty<?> t, Comparable<?> v) {
            state.func_177226_a(t, v);
        }

        @Override
        public void init() {
            IBlockState state = this.block.func_176223_P();
            for (Map.Entry<IProperty<?>, Comparable<?>> entry : this.properties.entrySet()) {
                IProperty<?> key = entry.getKey();
                Comparable<?> value = entry.getValue();
                this.setProperty(state, key, value);
            }
            this.block.func_180632_j(state);
        }

        @Override
        public ConfigBuilder gui(GuiHandler.GUI value) {
            this.block.gui = value;
            return this;
        }

        @Override
        public ConfigBuilder createTileEntity(Function<Void, ? extends TileEntity> value) {
            this.block.createTileEntity = value;
            return this;
        }

        @Override
        public ConfigBuilder getDrops(BiConsumer<List<ItemStack>, TileEntity> value) {
            this.block.getDrops = value;
            return this;
        }

        @Override
        public ConfigBuilder blockLayer(BlockRenderLayer value) {
            this.block.blockRenderLayer = value;
            return this;
        }

        @Override
        public ConfigBuilder renderType(EnumBlockRenderType value) {
            this.block.blockRenderType = value;
            return this;
        }
    }

    public static interface ConfigBuilder {
        public ConfigBuilder resistance(float var1);

        public ConfigBuilder hardness(float var1);

        public <T extends Comparable<T>, V extends T> ConfigBuilder with(IProperty<T> var1, V var2);

        public ConfigBuilder blockLayer(BlockRenderLayer var1);

        public ConfigBuilder renderType(EnumBlockRenderType var1);

        public ConfigBuilder gui(GuiHandler.GUI var1);

        public ConfigBuilder createTileEntity(Function<Void, ? extends TileEntity> var1);

        public ConfigBuilder getDrops(BiConsumer<List<ItemStack>, TileEntity> var1);

        public void init();
    }
}

