/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import paulojjj.solarenergy.Tier;
import paulojjj.solarenergy.blocks.EnergyNetworkBlock;
import paulojjj.solarenergy.gui.GuiHandler;
import paulojjj.solarenergy.tiles.BatteryTileEntity;

public class Battery
extends EnergyNetworkBlock<BatteryTileEntity> {
    public static PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public Battery(Tier tier) {
        this.configBuilder().with(FACING, EnumFacing.NORTH).gui(GuiHandler.GUI.BATTERY).createTileEntity(x -> new BatteryTileEntity(tier)).getDrops(this::setDropNBT).init();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public void setDropNBT(List<ItemStack> drops, TileEntity tileEntity) {
        BatteryTileEntity te = (BatteryTileEntity)tileEntity;
        ItemStack stack = drops.iterator().next();
        NBTTagCompound nbt = new NBTTagCompound();
        stack.func_77982_d(nbt);
        nbt.func_74780_a("Energy", te.getUltraEnergyStored());
        nbt.func_74780_a("MaxEnergy", te.getMaxUltraEnergyStored());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            double energy = stack.func_77978_p().func_74769_h("Energy");
            double maxEnergy = stack.func_77978_p().func_74769_h("MaxEnergy");
            BatteryTileEntity te = (BatteryTileEntity)worldIn.func_175625_s(pos);
            te.setUltraEnergyStored(energy);
            te.setMaxUltraEnergyStored(maxEnergy);
        }
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        int height = Math.round(placer.field_70125_A);
        if (height >= 65) {
            facing = EnumFacing.UP;
        } else if (height <= -30) {
            facing = EnumFacing.DOWN;
        }
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing));
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)facing));
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }
}

