/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import paulojjj.solarenergy.EnergyFormatter;
import paulojjj.solarenergy.Tier;
import paulojjj.solarenergy.blocks.Battery;
import paulojjj.solarenergy.tiles.BatteryTileEntity;

public class BatteryItemBlock
extends ItemBlock {
    public BatteryItemBlock(Tier tier) {
        super((Block)new Battery(tier));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        double energy = 0.0;
        double capacity = 0.0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            energy = nbt.func_74769_h("Energy");
            capacity = nbt.func_74769_h("MaxEnergy");
        } else {
            BatteryTileEntity te = (BatteryTileEntity)this.func_179223_d().createTileEntity(worldIn, this.func_179223_d().func_176223_P());
            energy = te.getUltraEnergyStored();
            capacity = te.getMaxUltraEnergyStored();
        }
        tooltip.add(String.format("%s: %s", I18n.func_135052_a((String)"solarenergy.stored_energy", (Object[])new Object[0]), EnergyFormatter.format(energy)));
        tooltip.add(String.format("%s: %s", I18n.func_135052_a((String)"solarenergy.capacity", (Object[])new Object[0]), EnergyFormatter.format(capacity)));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77978_p() != null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            double energy = nbt.func_74769_h("Energy");
            double capacity = nbt.func_74769_h("MaxEnergy");
            return 1.0 - energy / capacity;
        }
        return super.getDurabilityForDisplay(stack);
    }
}

