/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import paulojjj.solarenergy.EnergyFormatter;
import paulojjj.solarenergy.Tier;
import paulojjj.solarenergy.blocks.SolarGenerator;
import paulojjj.solarenergy.tiles.SolarGeneratorTileEntity;

public class SolarGeneratorItemBlock
extends ItemBlock {
    public SolarGeneratorItemBlock(Tier tier) {
        super((Block)new SolarGenerator(tier));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        SolarGeneratorTileEntity te = (SolarGeneratorTileEntity)this.func_179223_d().createTileEntity(worldIn, this.func_179223_d().func_176223_P());
        double production = te.getMaxProduction();
        tooltip.add(String.format("%s: %s/t", I18n.func_135052_a((String)"solarenergy.produces", (Object[])new Object[0]), EnergyFormatter.format(production)));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77978_p() != null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            double energy = nbt.func_74769_h("Energy");
            double capacity = nbt.func_74769_h("MaxEnergy");
            return 1.0 - energy / capacity;
        }
        return super.getDurabilityForDisplay(stack);
    }
}

