/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.net;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import scala.collection.mutable.HashSet;

public class MessageSerializer {
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public static Class<?> getGenericClass(Collection<?> collection, Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            return (Class)pType.getActualTypeArguments()[0];
        }
        throw new RuntimeException("Could not get generic class");
    }

    protected void write(Object object, Field field, ByteBuf buf) {
        Object value;
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        Class<?> type = field.getType();
        try {
            value = field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Error writing field", e);
        }
        this.write(buf, type, value, field.getGenericType());
    }

    private void write(ByteBuf buf, Class<?> type, Object value, Type genericType) {
        if (type == Boolean.TYPE || type.equals(Boolean.class)) {
            buf.writeBoolean(((Boolean)value).booleanValue());
        } else if (type == Byte.TYPE || type.equals(Byte.class)) {
            buf.writeByte((int)((Byte)value).byteValue());
        } else if (type == Short.TYPE || type.equals(Short.class)) {
            buf.writeShort((int)((Short)value).shortValue());
        } else if (type == Integer.TYPE || type.equals(Integer.class)) {
            buf.writeInt(((Integer)value).intValue());
        } else if (type == Long.TYPE || type.equals(Long.class)) {
            buf.writeLong(((Long)value).longValue());
        } else if (type == Float.TYPE || type.equals(Float.class)) {
            buf.writeFloat(((Float)value).floatValue());
        } else if (type == Double.TYPE || type.equals(Double.class)) {
            buf.writeDouble(((Double)value).doubleValue());
        } else if (CharSequence.class.isAssignableFrom(type)) {
            CharSequence str = (CharSequence)value;
            buf.writeShort((int)((Short)value).shortValue());
            buf.writeCharSequence(str, CHARSET);
        } else if (Collection.class.isAssignableFrom(type)) {
            Collection collection = (Collection)value;
            Class<?> collectionClass = MessageSerializer.getGenericClass(collection, genericType);
            this.write(buf, Integer.class, collection.size(), (Type)((Object)Integer.class));
            for (Object v : collection) {
                this.write(buf, collectionClass, v, collectionClass);
            }
        } else if (ItemStack.class.isAssignableFrom(type)) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)((ItemStack)value));
        } else if (Item.class.isAssignableFrom(type)) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)new ItemStack((Item)value));
        } else {
            throw new UnsupportedOperationException("Field type " + type + " not supported");
        }
    }

    protected void read(Object object, Field field, ByteBuf buf) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        Class<?> type = field.getType();
        Object value = this.read(buf, type, field.getGenericType());
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Error reading field", e);
        }
    }

    private Object read(ByteBuf buf, Class<?> type, Type genericType) {
        ArrayList value = null;
        if (type == Boolean.TYPE || type.equals(Boolean.class)) {
            value = buf.readBoolean();
        } else if (type == Byte.TYPE || type.equals(Byte.class)) {
            value = buf.readByte();
        } else if (type == Short.TYPE || type.equals(Short.class)) {
            value = buf.readShort();
        } else if (type == Integer.TYPE || type.equals(Integer.class)) {
            value = buf.readInt();
        } else if (type == Long.TYPE || type.equals(Long.class)) {
            value = buf.readLong();
        } else if (type == Float.TYPE || type.equals(Float.class)) {
            value = Float.valueOf(buf.readFloat());
        } else if (type == Double.TYPE || type.equals(Double.class)) {
            value = buf.readDouble();
        } else if (CharSequence.class.isAssignableFrom(type)) {
            short length = buf.readShort();
            value = buf.readCharSequence((int)length, CHARSET);
        } else if (Collection.class.isAssignableFrom(type)) {
            Collection collection = value;
            Class<?> collectionMemberClass = MessageSerializer.getGenericClass(collection, genericType);
            if (!type.isInterface()) {
                try {
                    value = type.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            } else if (Set.class.isAssignableFrom(type)) {
                value = new HashSet();
            } else if (List.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type)) {
                value = new ArrayList();
            } else {
                throw new RuntimeException("Collection type not supported " + type);
            }
            int size = (Integer)this.read(buf, Integer.class, (Type)((Object)Integer.class));
            for (int i = 0; i < size; ++i) {
                Object memberValue = this.read(buf, collectionMemberClass, collectionMemberClass);
                ((Collection)value).add(memberValue);
            }
        } else if (ItemStack.class.isAssignableFrom(type)) {
            value = ByteBufUtils.readItemStack((ByteBuf)buf);
        } else if (Item.class.isAssignableFrom(type)) {
            value = ByteBufUtils.readItemStack((ByteBuf)buf).func_77973_b();
        } else {
            throw new UnsupportedOperationException("Field type " + type + " not supported");
        }
        return value;
    }

    protected List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            Field[] classFields = clazz.getDeclaredFields();
            fields.addAll(Arrays.asList(classFields));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public void write(Object message, ByteBuf buf) {
        for (Field field : this.getFields(message.getClass())) {
            this.write(message, field, buf);
        }
    }

    public <T> T read(Class<T> messageClass, ByteBuf buf) {
        T message;
        try {
            message = messageClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Exception creating message instance", e);
        }
        for (Field field : this.getFields(messageClass)) {
            this.read(message, field, buf);
        }
        return message;
    }
}

