/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.networks;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import paulojjj.solarenergy.IUltraEnergyStorage;
import paulojjj.solarenergy.Log;
import paulojjj.solarenergy.TickHandler;
import paulojjj.solarenergy.networks.INetwork;
import paulojjj.solarenergy.networks.INetworkMember;

public abstract class BaseNetwork<T extends TileEntity>
implements INetwork<T> {
    protected boolean valid = true;
    protected Set<T> tiles = new HashSet<T>();
    protected Map<T, Map<EnumFacing, IEnergyStorage>> storages = new HashMap<T, Map<EnumFacing, IEnergyStorage>>();
    protected World world;
    protected double energyStored = 0.0;
    protected double maxEnergyStored = 0.0;
    protected boolean canReceive = false;
    protected boolean canExtract = false;
    protected double receivedSinceLastTick = 0.0;
    protected double sentSinceLastTick = 0.0;
    protected double energyInput = 0.0;
    protected double energyOutput = 0.0;
    protected long lastUpdatedTick = 0L;
    protected boolean sending = false;
    ReentrantLock lock = new ReentrantLock();

    protected boolean canAdd(T tileEntity) {
        return tileEntity != null && !tileEntity.func_145837_r() && this.getTileClass().isInstance(tileEntity) && tileEntity.func_145830_o() && this.world.func_175667_e(tileEntity.func_174877_v());
    }

    @Override
    public INetwork<T> init(T initialTile) {
        TileEntity neighbor;
        BaseNetwork network;
        if (initialTile == null) {
            return this;
        }
        this.world = initialTile.func_145831_w();
        Set<T> neighbors = this.getNeighbors(initialTile);
        if (!neighbors.isEmpty() && (network = (BaseNetwork)((INetworkMember)(neighbor = (TileEntity)neighbors.iterator().next())).getNetwork()) != null) {
            network.addTile(initialTile);
            this.destroy();
            return network;
        }
        this.updateNetwork(initialTile);
        if (this.tiles.isEmpty()) {
            this.destroy(false);
        }
        return this;
    }

    protected INetwork<T> init(Set<T> tiles, Map<T, Map<EnumFacing, IEnergyStorage>> storages) {
        this.world = ((TileEntity)tiles.iterator().next()).func_145831_w();
        this.tiles.addAll(tiles);
        this.storages.putAll(storages);
        for (TileEntity tile : tiles) {
            ((INetworkMember)tile).setNetwork(this);
        }
        return this;
    }

    protected void updateNetwork(T initialTile) {
        if (!this.canAdd(initialTile)) {
            return;
        }
        if (!this.tiles.contains(initialTile)) {
            this.addTile(initialTile);
        }
        Set<T> connected = this.scanConnected(initialTile);
        HashSet<TileEntity> orphans = new HashSet<TileEntity>();
        for (TileEntity tile : this.tiles) {
            if (connected.contains(tile)) continue;
            orphans.add(tile);
        }
        while (!orphans.isEmpty()) {
            TileEntity nextOrphan = null;
            Iterator it = orphans.iterator();
            while (it.hasNext() && !this.canAdd(nextOrphan = (TileEntity)it.next())) {
                it.remove();
            }
            if (nextOrphan == null) break;
            Set<TileEntity> newNetworkTiles = this.scanConnected(nextOrphan);
            if (newNetworkTiles.size() <= 0) continue;
            INetwork<TileEntity> newNetwork = this.split(newNetworkTiles);
            orphans.removeAll(newNetwork.getTiles());
        }
        for (TileEntity tile : connected) {
            if (this.tiles.contains(tile)) continue;
            this.addTile(tile);
        }
        this.updateStorages();
        if (this.tiles.isEmpty()) {
            this.destroy();
        }
    }

    protected TileEntity getTileEntity(BlockPos pos) {
        return this.world.func_175667_e(pos) ? this.world.func_175625_s(pos) : null;
    }

    protected Map<EnumFacing, IEnergyStorage> getNeighborStorages(TileEntity tileEntity, BiFunction<IEnergyStorage, EnumFacing, Boolean> canAdd) {
        BlockPos pos = tileEntity.func_174877_v();
        HashMap<EnumFacing, IEnergyStorage> storages = new HashMap<EnumFacing, IEnergyStorage>();
        for (EnumFacing facing : EnumFacing.values()) {
            IEnergyStorage energyStorage;
            TileEntity tile = this.getTileEntity(pos.func_177972_a(facing));
            if (tile == null || tile.getClass().equals(tileEntity.getClass()) || !tile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()) || !canAdd.apply(energyStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d()), facing).booleanValue()) continue;
            storages.put(facing, energyStorage);
        }
        return storages;
    }

    protected Map<EnumFacing, IEnergyStorage> getStorages(TileEntity tileEntity) {
        return this.getNeighborStorages(tileEntity, (s, f) -> true);
    }

    protected Map<EnumFacing, IEnergyStorage> getOrCreateStorageMap(T tile) {
        Map<EnumFacing, IEnergyStorage> storagesMap = this.storages.get(tile);
        if (storagesMap == null) {
            storagesMap = new HashMap<EnumFacing, IEnergyStorage>();
            this.storages.put(tile, storagesMap);
        }
        return storagesMap;
    }

    protected void updateStorages() {
        this.storages.clear();
        for (TileEntity tile : this.tiles) {
            Map<EnumFacing, IEnergyStorage> tileStorages = this.getStorages(tile);
            this.storages.put(tile, tileStorages);
        }
    }

    protected void addTile(T tile) {
        if (tile == null || !this.canAdd(tile) || this.tiles.contains(tile)) {
            return;
        }
        Log.info("Adding tile at " + tile.func_174877_v() + " to network " + this);
        ((INetworkMember)tile).setNetwork(this);
        this.tiles.add(tile);
        Map<EnumFacing, IEnergyStorage> storages = this.getStorages((TileEntity)tile);
        if (!storages.isEmpty()) {
            this.storages.put(tile, storages);
        }
        Set<T> neighbors = this.getNeighbors(tile);
        for (TileEntity neighbor : neighbors) {
            INetwork<?> neighborNetwork = ((INetworkMember)neighbor).getNetwork();
            if (neighborNetwork == null || neighborNetwork == this || !this.getTileClass().equals(neighborNetwork.getTileClass())) continue;
            this.merge(neighborNetwork);
        }
    }

    protected void merge(INetwork<T> other) {
        Log.info("Merging network " + this + " with " + other);
        for (TileEntity tile : other.getTiles()) {
            this.tiles.add(tile);
            ((INetworkMember)tile).setNetwork(this);
            this.storages.putAll(other.getStorages());
        }
        Log.info("Final network " + this);
        other.destroy();
    }

    protected void removeTiles(Collection<T> tilesRemoved) {
        this.tiles.removeAll(tilesRemoved);
        for (TileEntity tile : tilesRemoved) {
            ((INetworkMember)tile).setNetwork(null);
        }
        if (this.tiles.isEmpty()) {
            this.destroy();
            return;
        }
        this.updateNetwork((TileEntity)this.tiles.iterator().next());
    }

    @Override
    public void onBlockRemoved(T tile) {
        this.removeTiles(Arrays.asList(tile));
    }

    public Set<T> getTilesInChunk(ChunkPos chunkPos) {
        int chunkX = chunkPos.field_77276_a;
        int chunkZ = chunkPos.field_77275_b;
        HashSet<TileEntity> tilesInChunk = new HashSet<TileEntity>();
        for (TileEntity tile : this.getTiles()) {
            BlockPos pos = tile.func_174877_v();
            int tileChunkX = pos.func_177958_n() >> 4;
            int tileChunkZ = pos.func_177952_p() >> 4;
            if (tileChunkX != chunkX || tileChunkZ != chunkZ) continue;
            tilesInChunk.add(tile);
        }
        return tilesInChunk;
    }

    @Override
    public void onChunkUnload(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Set<Object> tilesInChunk = new HashSet();
        Log.info("Chunk  " + chunkPos + "unloaded");
        tilesInChunk = this.getTilesInChunk(chunkPos);
        if (tilesInChunk.size() == 0) {
            return;
        }
        this.removeTiles(tilesInChunk);
    }

    @Override
    public void onNeighborChanged(T source, BlockPos neighborPos) {
        this.storages.remove(source);
        for (Map.Entry<EnumFacing, IEnergyStorage> entry : this.getStorages((TileEntity)source).entrySet()) {
            this.getOrCreateStorageMap(source).put(entry.getKey(), entry.getValue());
        }
    }

    protected INetwork<T> split(Set<T> newNetworkTiles) {
        Log.info("Splitting network " + this);
        try {
            HashMap<TileEntity, Map<EnumFacing, IEnergyStorage>> newNetworkStorages = new HashMap<TileEntity, Map<EnumFacing, IEnergyStorage>>();
            for (TileEntity tile : newNetworkTiles) {
                if (!this.storages.containsKey(tile)) continue;
                newNetworkStorages.put(tile, this.storages.get(tile));
            }
            BaseNetwork newNetwork = (BaseNetwork)((BaseNetwork)this.getClass().newInstance()).init(newNetworkTiles, newNetworkStorages);
            this.tiles.removeAll(newNetwork.getTiles());
            Log.info("Network tiles: " + this);
            Log.info("Network created: " + newNetwork);
            return newNetwork;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Network split error", e);
        }
    }

    protected static <TE extends TileEntity> TE as(Class<TE> tileClass, Object obj) {
        if (tileClass.isInstance(obj)) {
            return (TE)((TileEntity)tileClass.cast(obj));
        }
        return null;
    }

    protected Set<T> scanConnected(T initialTile) {
        Log.info("Scanning connected tiles for " + initialTile.func_174877_v());
        long start = System.nanoTime();
        HashSet<T> scanned = new HashSet<T>();
        HashSet<T> connected = new HashSet<T>();
        if (this.canAdd(initialTile)) {
            connected.add(initialTile);
        }
        scanned.add(initialTile);
        this.scanNeighbors(initialTile, connected, scanned);
        double nanos = System.nanoTime() - start;
        double ms = nanos / 1000000.0;
        Log.info(String.format("Scanning returned %d tiles in %.3fms", connected.size(), ms));
        return connected;
    }

    protected void scanNeighbors(T tile, Set<T> connected, Set<T> scanned) {
        if (this.canAdd(tile) && !scanned.contains(tile)) {
            connected.add(tile);
            scanned.add(tile);
        }
        for (TileEntity neighbor : this.getNeighbors(tile)) {
            if (scanned.contains(neighbor)) continue;
            connected.add(neighbor);
            scanned.add(neighbor);
            this.scanNeighbors(neighbor, connected, scanned);
        }
    }

    public EnumFacing[] getPossibleNeighborsPositions(T tile) {
        return EnumFacing.field_82609_l;
    }

    Set<T> getNeighbors(T tile) {
        HashSet neighbors = new HashSet();
        for (EnumFacing facing : this.getPossibleNeighborsPositions(tile)) {
            BlockPos neighborPos = tile.func_174877_v().func_177972_a(facing);
            Object neighbor = BaseNetwork.as(this.getTileClass(), this.getTileEntity(neighborPos));
            if (neighbor == null || !this.canAdd(tile)) continue;
            neighbors.add(neighbor);
        }
        return neighbors;
    }

    @Override
    public Set<T> getTiles() {
        return this.tiles;
    }

    @Override
    public Map<T, Map<EnumFacing, IEnergyStorage>> getStorages() {
        return this.storages;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void destroy() {
        this.destroy(true);
    }

    public void destroy(boolean log) {
        this.tiles.clear();
        this.valid = false;
        if (log) {
            Log.info("Network " + this + " destroyed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        if (this.world.field_72995_K) {
            return;
        }
        if (TickHandler.getTick() == this.lastUpdatedTick) {
            return;
        }
        BaseNetwork baseNetwork = this;
        synchronized (baseNetwork) {
            this.lastUpdatedTick = TickHandler.getTick();
            this.energyStored = this.tiles.stream().map(x -> ((IUltraEnergyStorage)x).getUltraEnergyStored()).collect(Collectors.summingDouble(x -> x));
            this.maxEnergyStored = this.tiles.stream().map(x -> ((IUltraEnergyStorage)x).getMaxUltraEnergyStored()).collect(Collectors.summingDouble(x -> x));
            this.canExtract = ((IEnergyStorage)((TileEntity)this.tiles.iterator().next())).canExtract();
            this.canReceive = ((IEnergyStorage)((TileEntity)this.tiles.iterator().next())).canReceive();
            if (this.canExtract()) {
                double sent = this.sendToConsumers(this.energyStored, false);
                this.extractUltraEnergy(sent, false);
            }
            this.energyOutput = this.sentSinceLastTick;
            this.energyInput = this.receivedSinceLastTick;
            this.receivedSinceLastTick = 0.0;
            this.sentSinceLastTick = 0.0;
        }
    }

    double sendEnergy(IEnergyStorage consumer, double maxEnergy, boolean simulate) {
        if (consumer instanceof IUltraEnergyStorage) {
            return this.sendEnergy((IUltraEnergyStorage)consumer, maxEnergy, simulate);
        }
        int maxEnergyInt = (int)Math.min(2.147483647E9, maxEnergy);
        if (this.sending) {
            return 0.0;
        }
        this.sending = true;
        int sent = consumer.receiveEnergy(maxEnergyInt, simulate);
        this.sending = false;
        return sent;
    }

    double sendEnergy(IUltraEnergyStorage consumer, double maxEnergy, boolean simulate) {
        if (this.sending) {
            return 0.0;
        }
        this.sending = true;
        double sent = consumer.receiveUltraEnergy(maxEnergy, simulate);
        this.sending = false;
        if (sent == 0.0) {
            return 0.0;
        }
        return sent;
    }

    protected Set<IEnergyStorage> getStorages(TriFunction<T, EnumFacing, IEnergyStorage, Boolean> filter) {
        HashSet<IEnergyStorage> storages = new HashSet<IEnergyStorage>();
        for (Map.Entry<T, Map<EnumFacing, IEnergyStorage>> storageEntry : this.storages.entrySet()) {
            for (Map.Entry<EnumFacing, IEnergyStorage> entry : storageEntry.getValue().entrySet()) {
                if (!filter.apply((TileEntity)storageEntry.getKey(), entry.getKey(), entry.getValue()).booleanValue()) continue;
                storages.add(entry.getValue());
            }
        }
        return storages;
    }

    protected Set<IEnergyStorage> getConsumers() {
        return this.getStorages((T t, EnumFacing f, IEnergyStorage s) -> s.canReceive());
    }

    protected Set<IEnergyStorage> getProducers() {
        return this.getStorages((T t, EnumFacing f, IEnergyStorage s) -> s.canExtract());
    }

    protected double sendEqually(Set<IEnergyStorage> activeConsumers, double maxEnergy, boolean simulate) {
        double totalSent = 0.0;
        double lastTotalSent = -1.0;
        while (!activeConsumers.isEmpty() && totalSent < maxEnergy && lastTotalSent != totalSent) {
            lastTotalSent = totalSent;
            Iterator<IEnergyStorage> it = activeConsumers.iterator();
            double consumerSlice = Math.floor((maxEnergy - totalSent) / (double)activeConsumers.size());
            if (consumerSlice == 0.0) {
                consumerSlice = 1.0;
            }
            while (it.hasNext()) {
                double consumerMax;
                IEnergyStorage consumer = it.next();
                double sent = this.sendEnergy(consumer, consumerMax = Math.min(maxEnergy - totalSent, consumerSlice), simulate);
                if (sent == 0.0) {
                    it.remove();
                }
                totalSent += sent;
            }
        }
        return totalSent;
    }

    protected double sendToConsumers(double maxEnergy, boolean simulate) {
        double energyNeeded = 0.0;
        HashSet<IEnergyStorage> activeConsumers = new HashSet<IEnergyStorage>();
        for (IEnergyStorage consumer : this.getConsumers()) {
            double consumerNeeds = this.sendEnergy(consumer, Double.MAX_VALUE, true);
            energyNeeded += consumerNeeds;
            if (!(consumerNeeds > 0.0)) continue;
            activeConsumers.add(consumer);
        }
        if (simulate) {
            return energyNeeded;
        }
        return this.sendEqually(activeConsumers, maxEnergy, simulate);
    }

    double extractEnergy(IEnergyStorage producer, double maxExtract, boolean simulate) {
        if (producer instanceof IUltraEnergyStorage) {
            return (int)this.extractEnergy((IUltraEnergyStorage)producer, maxExtract, simulate);
        }
        int maxExtractInt = (int)Math.min(2.147483647E9, maxExtract);
        double received = producer.extractEnergy(maxExtractInt, simulate);
        if (received == 0.0) {
            return 0.0;
        }
        return this.receiveEnergy((int)received, simulate);
    }

    double extractEnergy(IUltraEnergyStorage producer, double maxExtract, boolean simulate) {
        double received = producer.extractUltraEnergy(maxExtract, simulate);
        if (received == 0.0) {
            return 0.0;
        }
        return this.receiveUltraEnergy(received, simulate);
    }

    protected void extractEnergyFromProducers(boolean simulate) {
        Set<IEnergyStorage> producers = this.getProducers();
        for (IEnergyStorage producer : producers) {
            double maxExtract = this.getMaxUltraEnergyStored() - this.getUltraEnergyStored();
            this.extractEnergy(producer, maxExtract, simulate);
        }
    }

    public String toString() {
        return super.toString() + "[size=" + this.tiles.size() + "]";
    }

    void forEachTile(Consumer<T> consumer) {
        for (TileEntity tile : this.tiles) {
            consumer.accept(tile);
        }
    }

    @Override
    public double getUltraEnergyStored() {
        return this.energyStored;
    }

    @Override
    public double getMaxUltraEnergyStored() {
        return this.maxEnergyStored;
    }

    @Override
    public double extractUltraEnergy(double maxExtract, boolean simulate) {
        maxExtract = Math.min(maxExtract, this.energyStored);
        if (this.energyStored == 0.0) {
            return 0.0;
        }
        double totalExtracted = 0.0;
        for (TileEntity tile : this.tiles) {
            if (!((IEnergyStorage)tile).canExtract()) continue;
            double extracted = ((IUltraEnergyStorage)tile).extractUltraEnergy(maxExtract - totalExtracted, simulate);
            totalExtracted += extracted;
            if (!simulate) {
                this.energyStored -= extracted;
                this.sentSinceLastTick += extracted;
            }
            if (extracted != maxExtract) continue;
            break;
        }
        return totalExtracted;
    }

    @Override
    public double receiveUltraEnergy(double maxReceive, boolean simulate) {
        if (this.maxEnergyStored == 0.0 || this.energyStored == this.maxEnergyStored || maxReceive == 0.0) {
            return 0.0;
        }
        double totalReceived = 0.0;
        for (TileEntity tile : this.tiles) {
            if (!((IEnergyStorage)tile).canReceive()) continue;
            double received = ((IUltraEnergyStorage)tile).receiveUltraEnergy(maxReceive - totalReceived, simulate);
            totalReceived += received;
            if (!simulate) {
                this.energyStored += received;
                this.receivedSinceLastTick += received;
            }
            if (totalReceived != maxReceive) continue;
            break;
        }
        return totalReceived;
    }

    public boolean canExtract() {
        return this.canExtract;
    }

    public boolean canReceive() {
        return this.canReceive;
    }

    @Override
    public double getEnergyInput() {
        return this.energyInput;
    }

    @Override
    public double getEnergyOutput() {
        return this.energyOutput;
    }

    protected static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

