/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.tiles;

import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import paulojjj.solarenergy.ItemStackHandlerWrapper;
import paulojjj.solarenergy.TickHandler;
import paulojjj.solarenergy.net.IMessageListener;
import paulojjj.solarenergy.net.PacketManager;
import paulojjj.solarenergy.recipes.EnergyAssemblerRecipe;
import paulojjj.solarenergy.recipes.RecipeHandler;
import paulojjj.solarenergy.tiles.EnergyStorageTileEntity;

public class EnergyAssemblerTileEntity
extends EnergyStorageTileEntity
implements ITickable,
IMessageListener<EnergyAssemblerTileUpdateMessage> {
    public static final int UPDATE_TICKS = 10;
    private Item assemblingItem;
    private Item resultItem;
    private ItemStackHandler itemHandler;
    private IItemHandler playerHandler;
    private IItemHandler internalHandler;
    private IItemHandler capabilityHandler;
    private long lastUpdate = 0L;

    public Item getAssemblingItem() {
        return this.assemblingItem;
    }

    public Item getResultItem() {
        return this.resultItem;
    }

    public IItemHandler getPlayerHandler() {
        return this.playerHandler;
    }

    protected void initItemHandlers(ItemStackHandlerWrapper.SlotType ... slotTypes) {
        this.itemHandler = new ItemStackHandler(slotTypes.length);
        this.playerHandler = new ItemStackHandlerWrapper(this.itemHandler, ItemStackHandlerWrapper.HandlerType.PLAYER, slotTypes);
        this.internalHandler = new ItemStackHandlerWrapper(this.itemHandler, ItemStackHandlerWrapper.HandlerType.INTERNAL, slotTypes);
        this.capabilityHandler = new ItemStackHandlerWrapper(this.itemHandler, ItemStackHandlerWrapper.HandlerType.CAPABILITY, slotTypes);
    }

    public EnergyAssemblerTileEntity() {
        this.initItemHandlers(ItemStackHandlerWrapper.SlotType.INPUT, ItemStackHandlerWrapper.SlotType.OUTPUT);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.capabilityHandler;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ItemStack stack = new ItemStack(compound.func_74775_l("AssemblingItem"));
        this.assemblingItem = stack == ItemStack.field_190927_a ? null : stack.func_77973_b();
        NBTTagCompound inventory = compound.func_74775_l("Inventory");
        if (inventory != null) {
            this.itemHandler.deserializeNBT(inventory);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        NBTTagCompound itemCompound = new NBTTagCompound();
        ItemStack stack = this.assemblingItem == null ? ItemStack.field_190927_a : new ItemStack(this.assemblingItem, 1);
        stack.func_77955_b(itemCompound);
        compound.func_74782_a("AssemblingItem", (NBTBase)itemCompound);
        compound.func_74782_a("Inventory", (NBTBase)this.itemHandler.serializeNBT());
        return compound;
    }

    protected Optional<EnergyAssemblerRecipe> getRecipe(Item input) {
        return RecipeHandler.getEnergyAssemblerRecipe(input);
    }

    protected boolean canAssemble(Item item) {
        return this.getRecipe(item).isPresent();
    }

    protected double getEnergyToAssemble(Item item) {
        return this.getRecipe(item).get().getEnergyNeeded();
    }

    protected ItemStack getOutput(Item input) {
        return this.getRecipe(input).get().getOutput().func_77946_l();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    protected void updateClientEntity() {
        PacketManager.sendToAllTracking(this, new EnergyAssemblerTileUpdateMessage(this));
    }

    public void beginAssemble(Item item) {
        this.assemblingItem = item;
        this.energy = 0.0;
        this.maxEnergy = this.getEnergyToAssemble(item);
        this.resultItem = this.getOutput(item).func_77973_b();
        this.updateClientEntity();
    }

    public void endAssemble() {
        this.assemblingItem = null;
        this.resultItem = null;
        this.energy = 0.0;
        this.maxEnergy = 0.0;
        this.updateClientEntity();
    }

    @Override
    public void func_73660_a() {
        Item item;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K && this.maxEnergy > 0.0 && this.energy < this.maxEnergy) {
            this.energy += Math.min(this.input, this.maxEnergy - this.energy);
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.assemblingItem != null && this.assemblingItem != ItemStack.field_190927_a.func_77973_b()) {
            long tick = TickHandler.getTick();
            if (tick > this.lastUpdate + 10L) {
                this.updateClientEntity();
                this.lastUpdate = TickHandler.getTick();
            }
            if (this.energy >= this.maxEnergy) {
                ItemStack stack = this.getOutput(this.assemblingItem);
                if (this.internalHandler.insertItem(Slot.OUTPUT.ordinal(), stack, false) == ItemStack.field_190927_a) {
                    this.endAssemble();
                }
            }
        }
        if (this.assemblingItem != null && this.assemblingItem != ItemStack.field_190927_a.func_77973_b()) {
            return;
        }
        ItemStack input = this.internalHandler.getStackInSlot(Slot.INPUT.ordinal());
        if (!input.func_190926_b() && this.canAssemble(item = input.func_77973_b())) {
            ItemStack extracted = new ItemStack(item, 1);
            extracted = this.internalHandler.extractItem(Slot.INPUT.ordinal(), 1, false);
            if (extracted != ItemStack.field_190927_a) {
                this.beginAssemble(extracted.func_77973_b());
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.assemblingItem != null && this.assemblingItem != ItemStack.field_190927_a.func_77973_b()) {
            this.resultItem = this.getOutput(this.assemblingItem).func_77973_b();
        }
    }

    @Override
    public void onMessage(EnergyAssemblerTileUpdateMessage message) {
        this.energy = message.energyStored;
        this.maxEnergy = message.maxEnergyStored;
        this.resultItem = message.resultItem;
        this.input = message.input;
        this.output = message.output;
    }

    public static class EnergyAssemblerTileUpdateMessage
    extends EnergyStorageTileEntity.EnergyStorageContainerUpdateMessage {
        public Item resultItem;

        public EnergyAssemblerTileUpdateMessage() {
        }

        public EnergyAssemblerTileUpdateMessage(EnergyAssemblerTileEntity te) {
            super(te);
            this.resultItem = te.resultItem;
        }
    }

    public static enum Slot {
        INPUT,
        OUTPUT;

    }

    public static class EnergyAssemblerItemHandler
    extends ItemStackHandler {
        private TileEntity tileEntity;

        public EnergyAssemblerItemHandler(TileEntity tileEntity, int slots) {
            super(slots);
            this.tileEntity = tileEntity;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            this.tileEntity.func_70296_d();
        }
    }
}

