/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.tiles;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import paulojjj.solarenergy.Log;
import paulojjj.solarenergy.net.IMessageListener;
import paulojjj.solarenergy.net.PacketManager;
import paulojjj.solarenergy.networks.CapabilityDelegate;
import paulojjj.solarenergy.networks.INetwork;
import paulojjj.solarenergy.networks.INetworkMember;
import paulojjj.solarenergy.tiles.EnergyNetworkUpdateMessage;
import paulojjj.solarenergy.tiles.EnergyStorageTileEntity;

public abstract class EnergyNetworkTileEntity
extends EnergyStorageTileEntity
implements INetworkMember,
ITickable,
IMessageListener<EnergyNetworkUpdateMessage> {
    public static final int BLOCK_UPDATE = 2;
    public static final int UPDATE_BLOCK = 1;
    public static final int SEND_TO_CLIENT = 2;
    protected CapabilityDelegate delegate = new CapabilityDelegate(this.getNetwork());
    private INetwork<EnergyNetworkTileEntity> network = null;
    private boolean unloaded = false;
    private Set<EnumFacing> neighborStorages = new HashSet<EnumFacing>();

    public abstract Class<?> getNetworkClass();

    @Override
    public INetwork<?> getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(INetwork<?> network) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.network = network;
        this.delegate.setTarget(network);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)(this.field_145850_b.field_72995_K ? this : this.delegate);
        }
        return super.getCapability(capability, facing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            Log.info("TileEntity Loaded: " + this);
            INetwork.newInstance(this.getNetworkClass(), this);
            for (EnumFacing facing : EnumFacing.values()) {
                TileEntity te;
                BlockPos neighborPos;
                IEnergyStorage storage = this.getNeighborStorage(facing);
                if (storage != null) {
                    EnergyNetworkTileEntity energyNetworkTileEntity = this;
                    synchronized (energyNetworkTileEntity) {
                        this.neighborStorages.add(facing);
                    }
                }
                if (!this.field_145850_b.func_175667_e(neighborPos = this.field_174879_c.func_177972_a(facing)) || !((te = this.field_145850_b.func_175625_s(neighborPos)) instanceof EnergyNetworkTileEntity)) continue;
                EnergyNetworkTileEntity ente = (EnergyNetworkTileEntity)te;
                if (ente.network == null) continue;
                ente.onNeighborChanged(this.field_174879_c);
            }
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            int flags = 2;
            this.updateClientTileEntity();
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, flags);
        }
    }

    protected IEnergyStorage getNeighborStorage(EnumFacing facing) {
        BlockPos neighbosPos = this.field_174879_c.func_177972_a(facing);
        IEnergyStorage storage = null;
        if (this.field_145850_b.func_175667_e(neighbosPos)) {
            TileEntity te = this.field_145850_b.func_175625_s(neighbosPos);
            if (te == null) {
                return null;
            }
            if (te.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, facing);
            }
        }
        return storage;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            if (this.unloaded) {
                Log.warn("Invalidating unloaded TileEntity: " + this);
            }
            if (!this.unloaded && this.network != null) {
                this.network.onBlockRemoved(this);
            }
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K && !this.unloaded) {
            this.unloaded = true;
            if (this.network != null) {
                this.network.onChunkUnload(this.field_174879_c);
            }
        }
    }

    protected EnumFacing getNeighborFacing(BlockPos neighbor) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (!this.field_174879_c.func_177972_a(facing).equals((Object)neighbor)) continue;
            return facing;
        }
        throw new RuntimeException("Invalid neighbor " + neighbor + " from " + this.field_174879_c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateClientTileEntity() {
        EnergyNetworkUpdateMessage message = new EnergyNetworkUpdateMessage();
        ArrayList<Byte> neighbors = new ArrayList<Byte>();
        EnergyNetworkTileEntity energyNetworkTileEntity = this;
        synchronized (energyNetworkTileEntity) {
            for (EnumFacing facing : this.neighborStorages) {
                neighbors.add((byte)facing.ordinal());
            }
        }
        message.setNeighborStorages(neighbors);
        PacketManager.sendToAllTracking(this, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNeighborChanged(BlockPos neighborPos) {
        if (!this.field_145850_b.field_72995_K) {
            if (neighborPos.equals((Object)this.field_174879_c)) {
                return;
            }
            Log.info(this.field_174879_c + " neighbor changed: " + neighborPos);
            EnumFacing facing = this.getNeighborFacing(neighborPos);
            IEnergyStorage storage = this.getNeighborStorage(facing);
            EnergyNetworkTileEntity energyNetworkTileEntity = this;
            synchronized (energyNetworkTileEntity) {
                if (storage == null) {
                    this.neighborStorages.remove(facing);
                } else {
                    this.neighborStorages.add(facing);
                }
            }
            this.updateClientTileEntity();
            if (this.network != null) {
                this.network.onNeighborChanged(this, neighborPos);
            }
        }
    }

    @Override
    protected Object getContainerUpdateMessage() {
        double energy = this.getNetwork().getUltraEnergyStored();
        double maxEnergy = this.getNetwork().getMaxUltraEnergyStored();
        double input = this.getNetwork().getEnergyInput();
        double output = this.getNetwork().getEnergyOutput();
        return new EnergyStorageTileEntity.EnergyStorageContainerUpdateMessage(energy, maxEnergy, input, output);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K || !this.field_145850_b.func_175667_e(this.field_174879_c)) {
            return;
        }
        if (this.network != null) {
            this.network.update();
        }
    }

    public synchronized boolean hasStorage(EnumFacing facing) {
        return this.neighborStorages.contains(facing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        EnergyNetworkTileEntity energyNetworkTileEntity = this;
        synchronized (energyNetworkTileEntity) {
            int size = this.neighborStorages.size();
            byte[] neighbors = new byte[size];
            int i = 0;
            for (EnumFacing facing : this.neighborStorages) {
                neighbors[i++] = (byte)facing.ordinal();
            }
            nbt.func_74773_a("storages", neighbors);
        }
        return nbt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        byte[] storages = tag.func_74770_j("storages");
        EnergyNetworkTileEntity energyNetworkTileEntity = this;
        synchronized (energyNetworkTileEntity) {
            this.neighborStorages.clear();
            for (int i = 0; i < storages.length; ++i) {
                this.neighborStorages.add(EnumFacing.func_82600_a((int)storages[i]));
            }
        }
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public synchronized void onMessage(EnergyNetworkUpdateMessage message) {
        this.neighborStorages.clear();
        for (Byte f : message.getNeighborStorages()) {
            this.neighborStorages.add(EnumFacing.func_82600_a((int)f.byteValue()));
        }
    }
}

