/*
 * Decompiled with CFR 0.152.
 */
package paulojjj.solarenergy.tiles;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import paulojjj.solarenergy.IUltraEnergyStorage;
import paulojjj.solarenergy.net.PacketManager;

public abstract class EnergyStorageTileEntity
extends TileEntity
implements IUltraEnergyStorage,
ITickable {
    protected double energy = 0.0;
    protected double maxEnergy = 0.0;
    protected double sentSinceLastUpdate;
    protected double receivedSinceLastUpdate;
    protected double input;
    protected double output;
    private Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();

    protected Object getContainerUpdateMessage() {
        double energy = this.getUltraEnergyStored();
        double maxEnergy = this.getMaxUltraEnergyStored();
        double input = this.getInput();
        double output = this.getOutput();
        return new EnergyStorageContainerUpdateMessage(energy, maxEnergy, input, output);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public double extractUltraEnergy(double maxExtract, boolean simulate) {
        if (this.energy == 0.0 || !this.canExtract()) {
            return 0.0;
        }
        double sent = Math.min(maxExtract, this.energy);
        if (!simulate && sent > 0.0) {
            this.energy -= sent;
            this.sentSinceLastUpdate += sent;
            this.func_70296_d();
        }
        return sent;
    }

    @Override
    public double receiveUltraEnergy(double maxReceive, boolean simulate) {
        if (this.maxEnergy == 0.0 || this.energy == this.maxEnergy || !this.canReceive()) {
            return 0.0;
        }
        double received = Math.min(maxReceive, this.maxEnergy - this.energy);
        if (!simulate && received > 0.0) {
            this.energy += received;
            this.receivedSinceLastUpdate += received;
            this.func_70296_d();
        }
        return received;
    }

    @Override
    public double getUltraEnergyStored() {
        return this.energy;
    }

    public void setUltraEnergyStored(double value) {
        this.energy = value;
    }

    @Override
    public double getMaxUltraEnergyStored() {
        return this.maxEnergy;
    }

    public void setMaxUltraEnergyStored(double value) {
        this.maxEnergy = value;
    }

    public double getInput() {
        return this.input;
    }

    public double getOutput() {
        return this.output;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energy = compound.func_74769_h("Energy");
        this.maxEnergy = compound.func_74769_h("MaxEnergy");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74780_a("Energy", this.energy);
        compound.func_74780_a("MaxEnergy", this.maxEnergy);
        return compound;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.input = this.receivedSinceLastUpdate;
        this.output = this.sentSinceLastUpdate;
        this.receivedSinceLastUpdate = 0.0;
        this.sentSinceLastUpdate = 0.0;
        for (EntityPlayer player : this.playersUsing) {
            PacketManager.sendContainerUpdateMessage((EntityPlayerMP)player, this.getContainerUpdateMessage());
        }
    }

    public void onContainerOpened(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            this.playersUsing.add(player);
        }
    }

    public void onContainerClosed(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            this.playersUsing.remove(player);
        }
    }

    public String toString() {
        return super.toString() + " [position=" + this.field_174879_c + "]";
    }

    public static class EnergyStorageContainerUpdateMessage {
        public double energyStored;
        public double maxEnergyStored;
        public double input;
        public double output;

        public EnergyStorageContainerUpdateMessage() {
        }

        public EnergyStorageContainerUpdateMessage(EnergyStorageTileEntity te) {
            this(te.getUltraEnergyStored(), te.getMaxUltraEnergyStored(), te.getInput(), te.getOutput());
        }

        public EnergyStorageContainerUpdateMessage(double energyStored, double maxEnergyStored, double input, double output) {
            this.energyStored = energyStored;
            this.maxEnergyStored = maxEnergyStored;
            this.input = input;
            this.output = output;
        }
    }
}

