/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.tileentity.TileEntityGutter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class BlockGutter
extends BlockHorizontalFacing {
    public static final PropertyBool ACTIVE_LEFT = PropertyBool.func_177716_a((String)"active_left");
    public static final PropertyBool ACTIVE_RIGHT = PropertyBool.func_177716_a((String)"active_right");
    public static final PropertyBool ACTIVE_DOWN = PropertyBool.func_177716_a((String)"active_down");
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.4375, 0.0, 1.0, 0.75, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.4375, 0.0, 1.0, 0.75, 0.3125);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.4375, 0.6875, 1.0, 0.75, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.4375, 0.0, 0.3125, 0.75, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.6875, 0.4375, 0.0, 1.0, 0.75, 1.0);
    protected static final AxisAlignedBB NC_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 0.8125);
    protected static final AxisAlignedBB SC_AABB = new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.75, 1.0);
    protected static final AxisAlignedBB WC_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.75, 1.0);
    protected static final AxisAlignedBB EC_AABB = new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.75, 1.0);

    public BlockGutter(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(I18n.func_135052_a((String)"info.industrialrenewal.produces", (Object[])new Object[0]) + ": ");
        tooltip.add(Blocks.field_150355_j.func_149732_F() + " 1" + " mB/t " + I18n.func_135052_a((String)"info.industrialrenewal.gutter", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"info.industrialrenewal.gutter2", (Object[])new Object[0]));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    private Boolean downConnected(IBlockAccess world, BlockPos pos) {
        TileEntity tileEntityS = world.func_175625_s(pos.func_177972_a(EnumFacing.DOWN));
        return tileEntityS != null && !tileEntityS.func_145837_r() && tileEntityS.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
    }

    private Boolean leftConnected(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
        Block block = world.func_180495_p(pos.func_177972_a(face.func_176746_e().func_176734_d())).func_177230_c();
        if (block instanceof BlockGutter) {
            EnumFacing leftFace = (EnumFacing)world.func_180495_p(pos.func_177972_a(face.func_176746_e().func_176734_d())).func_177229_b((IProperty)FACING);
            return leftFace != face;
        }
        return true;
    }

    private Boolean rightConnected(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
        Block block = world.func_180495_p(pos.func_177972_a(face.func_176746_e())).func_177230_c();
        if (block instanceof BlockGutter) {
            EnumFacing rightFace = (EnumFacing)world.func_180495_p(pos.func_177972_a(face.func_176746_e())).func_177229_b((IProperty)FACING);
            return rightFace != face;
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)ACTIVE_DOWN, (Comparable)this.downConnected(world, pos)).func_177226_a((IProperty)ACTIVE_LEFT, (Comparable)this.leftConnected(state, world, pos)).func_177226_a((IProperty)ACTIVE_RIGHT, (Comparable)this.rightConnected(state, world, pos));
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE_LEFT, ACTIVE_RIGHT, ACTIVE_DOWN});
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState actualState = state.func_185899_b((IBlockAccess)worldIn, pos);
        EnumFacing face = (EnumFacing)actualState.func_177229_b((IProperty)FACING);
        Boolean active = (Boolean)actualState.func_177229_b((IProperty)ACTIVE_DOWN);
        if (face == EnumFacing.NORTH) {
            if (active.booleanValue()) {
                BlockGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NC_AABB);
            } else {
                BlockGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
            }
        }
        if (face == EnumFacing.SOUTH) {
            if (active.booleanValue()) {
                BlockGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SC_AABB);
            } else {
                BlockGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
            }
        }
        if (face == EnumFacing.WEST) {
            if (active.booleanValue()) {
                BlockGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WC_AABB);
            } else {
                BlockGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
            }
        }
        if (face == EnumFacing.EAST) {
            if (active.booleanValue()) {
                BlockGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EC_AABB);
            } else {
                BlockGutter.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = state.func_185899_b(source, pos);
        EnumFacing face = (EnumFacing)actualState.func_177229_b((IProperty)FACING);
        Boolean active = (Boolean)actualState.func_177229_b((IProperty)ACTIVE_DOWN);
        if (face == EnumFacing.NORTH) {
            if (active.booleanValue()) {
                return NC_AABB;
            }
            return NORTH_AABB;
        }
        if (face == EnumFacing.SOUTH) {
            if (active.booleanValue()) {
                return SC_AABB;
            }
            return SOUTH_AABB;
        }
        if (face == EnumFacing.WEST) {
            if (active.booleanValue()) {
                return WC_AABB;
            }
            return WEST_AABB;
        }
        if (face == EnumFacing.EAST) {
            if (active.booleanValue()) {
                return EC_AABB;
            }
            return EAST_AABB;
        }
        return null;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntityGutter createTileEntity(World world, IBlockState state) {
        return new TileEntityGutter();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

