/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.handlers;

import cassiokf.industrialrenewal.entity.EntityTenderBase;
import cassiokf.industrialrenewal.entity.LocomotiveBase;
import cassiokf.industrialrenewal.util.enums.EnumCouplingType;
import cassiokf.industrialrenewal.util.interfaces.ICoupleCart;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.vecmath.Vector2d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CouplingHandler {
    @Nullable
    public static EntityMinecart getCartFromUUID(@Nullable World world, @Nullable UUID id) {
        if (world == null || id == null) {
            return null;
        }
        if (world instanceof WorldServer) {
            Entity entity = ((WorldServer)world).func_175733_a(id);
            if (entity instanceof EntityMinecart && entity.func_70089_S()) {
                return (EntityMinecart)entity;
            }
        } else {
            for (Entity entity : world.field_72996_f) {
                if (!(entity instanceof EntityMinecart) || !entity.func_70089_S() || !entity.getPersistentID().equals(id)) continue;
                return (EntityMinecart)entity;
            }
        }
        return null;
    }

    public static void onMinecartTick(EntityMinecart cart) {
        boolean connectedA = CouplingHandler.updateCartVelocity(cart, EnumCouplingType.COUPLING_1);
        boolean connectedB = CouplingHandler.updateCartVelocity(cart, EnumCouplingType.COUPLING_2);
        if (connectedA || connectedB) {
            CouplingHandler.applyDrag(cart);
        }
    }

    private static void applyDrag(EntityMinecart cart) {
        cart.field_70159_w *= 0.99;
        cart.field_70179_y *= 0.99;
    }

    private static boolean updateCartVelocity(EntityMinecart cart1, EnumCouplingType ConnectionType) {
        EntityMinecart cart2 = CouplingHandler.getCartFromUUID(cart1.field_70170_p, CouplingHandler.getConnection(cart1, ConnectionType));
        if (cart2 != null && cart1 != cart2) {
            double dist = cart1.func_70032_d((Entity)cart2);
            if (dist > 10.0) {
                CouplingHandler.removeConnection(cart1, cart2);
                return false;
            }
            if (cart1 instanceof EntityTenderBase && cart2 instanceof LocomotiveBase && ((LocomotiveBase)cart2).tender != cart1) {
                ((LocomotiveBase)cart2).setTender((EntityTenderBase)cart1);
            } else if (cart2 instanceof EntityTenderBase && cart1 instanceof LocomotiveBase && ((LocomotiveBase)cart1).tender != cart2) {
                ((LocomotiveBase)cart1).setTender((EntityTenderBase)cart2);
            }
            Vector2d cart1Pos = new Vector2d(cart1.field_70165_t, cart1.field_70161_v);
            Vector2d cart2Pos = new Vector2d(cart2.field_70165_t, cart2.field_70161_v);
            Vector2d normalized = new Vector2d(cart2Pos.x - cart1Pos.x, cart2Pos.y - cart1Pos.y);
            normalized = CouplingHandler.normalize(normalized);
            CouplingHandler.applySpringForce(cart1, cart2, dist, normalized);
            CouplingHandler.applyDampingForce(cart1, cart2, normalized);
            return true;
        }
        return false;
    }

    public static Vector2d normalize(Vector2d toNorm) {
        double x = toNorm.x;
        double y = toNorm.y;
        double sqrt = Math.sqrt(x * x + y * y);
        if (sqrt != 0.0) {
            return new Vector2d(x / sqrt, y / sqrt);
        }
        return toNorm;
    }

    private static void applySpringForce(EntityMinecart cart1, EntityMinecart cart2, double distance, Vector2d normalized) {
        double stretch = 1.5 * (distance - (double)CouplingHandler.getDistanceBetween(cart1, cart2));
        double springX = stretch * normalized.getX();
        double springZ = stretch * normalized.getY();
        springX = CouplingHandler.limitForce(springX);
        springZ = CouplingHandler.limitForce(springZ);
        cart1.field_70159_w += springX;
        cart1.field_70179_y += springZ;
        cart2.field_70159_w -= springX;
        cart2.field_70179_y -= springZ;
    }

    private static void applyDampingForce(EntityMinecart cart1, EntityMinecart cart2, Vector2d norm) {
        Vector2d cart1Vel = new Vector2d(cart1.field_70159_w, cart1.field_70179_y);
        Vector2d cart2Vel = new Vector2d(cart2.field_70159_w, cart2.field_70179_y);
        double normal = (double)0.3f * ((cart2Vel.getX() - cart1Vel.getX()) * norm.getX() + (cart2Vel.getY() - cart1Vel.getY()) * norm.getY());
        double dampX = normal * norm.getX();
        double dampZ = normal * norm.getY();
        dampX = CouplingHandler.limitForce(dampX);
        dampZ = CouplingHandler.limitForce(dampZ);
        cart1.field_70159_w += dampX;
        cart1.field_70179_y += dampZ;
        cart2.field_70159_w -= dampX;
        cart2.field_70179_y -= dampZ;
    }

    private static double limitForce(double force) {
        return Math.copySign(Math.min(Math.abs(force), 6.0), force);
    }

    private static float getDistanceBetween(EntityMinecart cart1, EntityMinecart cart2) {
        float dist = 0.0f;
        dist = cart1 instanceof ICoupleCart ? (dist += ((ICoupleCart)cart1).getFixedDistance(cart2)) : (dist += 0.78f);
        dist = cart2 instanceof ICoupleCart ? (dist += ((ICoupleCart)cart2).getFixedDistance(cart1)) : (dist += 0.78f);
        return dist;
    }

    public static UUID getConnection(EntityMinecart cart, EnumCouplingType ConnectionType) {
        long high = cart.getEntityData().func_74763_f(ConnectionType.tagMostSigBits);
        long low = cart.getEntityData().func_74763_f(ConnectionType.tagLeastSigBits);
        return new UUID(high, low);
    }

    public static boolean isConnected(EntityMinecart cart1, EntityMinecart cart2) {
        if (cart1 == cart2) {
            return false;
        }
        UUID id1 = cart1.getPersistentID();
        UUID id2 = cart2.getPersistentID();
        boolean cart1Connected = id2.equals(CouplingHandler.getConnection(cart1, EnumCouplingType.COUPLING_1)) || id2.equals(CouplingHandler.getConnection(cart1, EnumCouplingType.COUPLING_2));
        boolean cart2Connected = id1.equals(CouplingHandler.getConnection(cart2, EnumCouplingType.COUPLING_1)) || id1.equals(CouplingHandler.getConnection(cart2, EnumCouplingType.COUPLING_2));
        return cart1Connected || cart2Connected;
    }

    public static void removeConnection(EntityMinecart one, EntityMinecart two) {
        EnumCouplingType firstConnection = CouplingHandler.getConnectionType(one, two);
        EnumCouplingType secondConnection = CouplingHandler.getConnectionType(two, one);
        if (firstConnection != null) {
            CouplingHandler.removeConnection(one, firstConnection);
        }
        if (secondConnection != null) {
            CouplingHandler.removeConnection(two, secondConnection);
        }
    }

    private static EnumCouplingType getConnectionType(EntityMinecart from, EntityMinecart to) {
        UUID id = to.getPersistentID();
        if (id.equals(CouplingHandler.getConnection(from, EnumCouplingType.COUPLING_1))) {
            return EnumCouplingType.COUPLING_1;
        }
        if (id.equals(CouplingHandler.getConnection(from, EnumCouplingType.COUPLING_2))) {
            return EnumCouplingType.COUPLING_2;
        }
        return null;
    }

    private static void removeConnection(EntityMinecart cart, EnumCouplingType ConnectionType) {
        cart.getEntityData().func_82580_o(ConnectionType.tagMostSigBits);
        cart.getEntityData().func_82580_o(ConnectionType.tagLeastSigBits);
    }
}

