/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.util.UUID;
import javax.annotation.Nonnull;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import pcl.opensecurity.Config;
import pcl.opensecurity.common.interfaces.IOwner;
import pcl.opensecurity.common.items.ItemCard;
import pcl.opensecurity.common.tileentity.TileEntityOSCamoBase;

public class TileEntityMagReader
extends TileEntityOSCamoBase
implements IOwner {
    public String data;
    private String eventName = "magData";
    private UUID ownerUUID;

    public TileEntityMagReader() {
        super("os_magreader");
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    }

    public boolean doRead(@Nonnull ItemStack itemStack, EntityPlayer em, EnumFacing side) {
        ItemCard.CardTag cardTag = new ItemCard.CardTag(itemStack);
        if (this.node.changeBuffer(-5.0) != 0.0 || !cardTag.isValid) {
            return false;
        }
        String user = Config.getConfig().getCategory("general").get("ignoreUUIDs").getBoolean() ? "player" : em.getDisplayNameString();
        this.node.sendToReachable("computer.signal", new Object[]{this.eventName, user, cardTag.dataTag, cardTag.localUUID, cardTag.locked, side.func_176745_a()});
        return true;
    }

    @Callback(doc="function(String:name):boolean; Sets the name of the event that gets sent when a card is swipped", direct=true)
    public Object[] setEventName(Context context, Arguments args) {
        this.eventName = args.checkString(0);
        return new Object[]{true};
    }

    @Override
    public void setOwner(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public UUID getOwner() {
        return this.ownerUUID;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.ownerUUID = nbt.func_186855_b("owner") ? nbt.func_186857_a("owner") : (nbt.func_74764_b("owner") ? UUID.fromString(nbt.func_74779_i("owner")) : null);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.ownerUUID != null) {
            nbt.func_186854_a("owner", this.ownerUUID);
        }
        return nbt;
    }

    @Override
    public boolean playerCanChangeCamo(EntityPlayer player) {
        return player.func_184812_l_() || this.getOwner() == null || this.getOwner().equals(player.func_110124_au());
    }
}

