/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.api.core.IAugmentable;
import cofh.api.item.IAugmentItem;
import cofh.api.item.ICreativeItem;
import cofh.api.item.ILeveledItem;
import cofh.api.item.IUpgradeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class AugmentHelper {
    private AugmentHelper() {
    }

    public static NBTTagCompound setItemStackTagAugments(NBTTagCompound tag, IAugmentable tile) {
        if (tile == null) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        AugmentHelper.writeAugmentsToNBT(tag, tile.getAugmentSlots());
        return tag;
    }

    public static void writeAugmentsToNBT(NBTTagCompound nbt, ItemStack[] augments) {
        if (augments.length <= 0) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < augments.length; ++i) {
            if (augments[i].func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Slot", i);
            augments[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Augments", (NBTBase)list);
    }

    public static boolean isAugmentItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IAugmentItem;
    }

    public static IAugmentItem.AugmentType getAugmentType(ItemStack stack) {
        return ((IAugmentItem)stack.func_77973_b()).getAugmentType(stack);
    }

    public static String getAugmentIdentifier(ItemStack stack) {
        return ((IAugmentItem)stack.func_77973_b()).getAugmentIdentifier(stack);
    }

    public static boolean isUpgradeItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof IUpgradeItem;
    }

    public static int getLevel(ItemStack stack) {
        if (stack.func_77973_b() instanceof ILeveledItem) {
            return ((ILeveledItem)stack.func_77973_b()).getLevel(stack);
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("Level")) {
            return -1;
        }
        return stack.func_77978_p().func_74771_c("Level");
    }

    public static ItemStack setLevel(ItemStack stack, int level) {
        if (stack.func_77973_b() instanceof ILeveledItem) {
            return ((ILeveledItem)stack.func_77973_b()).setLevel(stack, level);
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74774_a("Level", (byte)level);
        return stack;
    }

    public static boolean isCreative(ItemStack stack) {
        if (stack.func_77973_b() instanceof ICreativeItem) {
            return ((ICreativeItem)stack.func_77973_b()).isCreative(stack);
        }
        return false;
    }

    public static ItemStack setCreative(ItemStack stack) {
        if (stack.func_77973_b() instanceof ICreativeItem) {
            return ((ICreativeItem)stack.func_77973_b()).setCreativeTag(stack);
        }
        return stack;
    }

    public static IUpgradeItem.UpgradeType getUpgradeType(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IUpgradeItem)) {
            return IUpgradeItem.UpgradeType.INCREMENTAL;
        }
        return ((IUpgradeItem)stack.func_77973_b()).getUpgradeType(stack);
    }

    public static byte getUpgradeLevel(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IUpgradeItem)) {
            return -1;
        }
        return ((IUpgradeItem)stack.func_77973_b()).getUpgradeLevel(stack);
    }
}

