/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.ToolType;
import com.supermartijn642.core.block.BaseTileEntity;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseBlock
extends Block {
    private final boolean saveTileData;
    private final ToIntFunction<IBlockState> lightLevel;

    public BaseBlock(String registryName, boolean saveTileData, Properties properties) {
        super(properties.material, properties.mapColor);
        this.setRegistryName(registryName);
        this.func_149663_c(this.getRegistryName().func_110624_b() + "." + this.getRegistryName().func_110623_a());
        this.saveTileData = saveTileData;
        this.func_149672_a(properties.soundType);
        this.lightLevel = properties.lightLevel;
        this.func_149752_b(properties.resistance);
        this.func_149711_c(properties.hardness);
        this.func_149675_a(properties.ticksRandomly);
        this.setDefaultSlipperiness(properties.slipperiness);
        if (properties.harvestTool != null) {
            this.setHarvestLevel(properties.harvestTool.getName(), properties.harvestLevel);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!this.saveTileData) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagCompound nBTTagCompound = tag == null ? null : (tag = tag.func_74764_b("tileData") ? tag.func_74775_l("tileData") : null);
        if (tag == null || tag.func_82582_d()) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof BaseTileEntity) {
            ((BaseTileEntity)tile).readData(tag);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.addAll(this.getActualDrops(world, pos, state, fortune));
    }

    public List<ItemStack> getActualDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList drops = NonNullList.func_191196_a();
        super.getDrops(drops, world, pos, state, fortune);
        if (!this.saveTileData) {
            return drops;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof BaseTileEntity)) {
            return drops;
        }
        if (((BaseTileEntity)tile).destroyedByCreativePlayer) {
            return NonNullList.func_191196_a();
        }
        NBTTagCompound tileTag = ((BaseTileEntity)tile).writeItemStackData();
        if (tileTag == null || tileTag.func_82582_d()) {
            return drops;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tileData", (NBTBase)tileTag);
        for (ItemStack stack : drops) {
            if (!(stack.func_77973_b() instanceof ItemBlock) || ((ItemBlock)stack.func_77973_b()).func_179223_d() != this) continue;
            stack.func_77982_d(tag);
        }
        return drops;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        if (!this.saveTileData) {
            return stack;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof BaseTileEntity)) {
            return stack;
        }
        NBTTagCompound tileTag = ((BaseTileEntity)tile).writeItemStackData();
        if (tileTag == null || tileTag.func_82582_d()) {
            return stack;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tileData", (NBTBase)tileTag);
        if (stack.func_77973_b() instanceof ItemBlock && ((ItemBlock)stack.func_77973_b()).func_179223_d() == this) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public int func_149750_m(IBlockState state) {
        return this.lightLevel.applyAsInt(state);
    }

    public static class Properties {
        private final Material material;
        private final MapColor mapColor;
        private SoundType soundType = SoundType.field_185851_d;
        private ToIntFunction<IBlockState> lightLevel = state -> 0;
        private float resistance;
        private float hardness;
        private boolean requiresTool;
        private boolean ticksRandomly;
        private float slipperiness = 0.6f;
        private float speedFactor = 1.0f;
        private float jumpFactor = 1.0f;
        private int harvestLevel = -1;
        private ToolType harvestTool;
        private boolean variableOpacity;

        private Properties(Material material, MapColor color) {
            this.material = material;
            this.mapColor = color;
        }

        public static Properties create(Material material, MapColor color) {
            return new Properties(material, color);
        }

        public static Properties create(Material material, EnumDyeColor color) {
            return new Properties(material, MapColor.func_193558_a((EnumDyeColor)color));
        }

        public static Properties create(Material material) {
            return new Properties(material, material.func_151565_r());
        }

        public Properties harvestLevel(int harvestLevel) {
            this.harvestLevel = harvestLevel;
            return this;
        }

        public Properties harvestTool(ToolType harvestTool) {
            this.harvestTool = harvestTool;
            return this;
        }

        public int getHarvestLevel() {
            return this.harvestLevel;
        }

        public ToolType getHarvestTool() {
            return this.harvestTool;
        }

        public Properties slipperiness(float slipperinessIn) {
            this.slipperiness = slipperinessIn;
            return this;
        }

        public Properties speedFactor(float factor) {
            this.speedFactor = factor;
            return this;
        }

        public Properties jumpFactor(float factor) {
            this.jumpFactor = factor;
            return this;
        }

        public Properties sound(SoundType soundTypeIn) {
            this.soundType = soundTypeIn;
            return this;
        }

        public Properties setLightLevel(ToIntFunction<IBlockState> stateLightFunction) {
            this.lightLevel = stateLightFunction;
            return this;
        }

        public Properties hardnessAndResistance(float hardnessIn, float resistanceIn) {
            this.hardness = hardnessIn;
            this.resistance = Math.max(0.0f, resistanceIn);
            return this;
        }

        public Properties zeroHardnessAndResistance() {
            return this.hardnessAndResistance(0.0f);
        }

        public Properties hardnessAndResistance(float hardnessAndResistance) {
            this.hardnessAndResistance(hardnessAndResistance, hardnessAndResistance);
            return this;
        }

        public Properties tickRandomly() {
            this.ticksRandomly = true;
            return this;
        }

        public Properties setRequiresTool() {
            this.requiresTool = true;
            return this;
        }
    }
}

