/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.core.gui.widget.ITickableWidget;
import com.supermartijn642.core.gui.widget.TextFieldWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class BaseContainerScreen<T extends BaseContainer>
extends GuiContainer {
    private static final ResourceLocation SLOT_TEXTURE = new ResourceLocation("supermartijn642corelib", "textures/gui/slot.png");
    protected final List<Widget> widgets = new LinkedList<Widget>();
    protected final List<ITickableWidget> tickableWidgets = new LinkedList<ITickableWidget>();
    protected final T container;
    private boolean drawSlots = true;
    protected ITextComponent title;
    protected FontRenderer font;

    public BaseContainerScreen(T screenContainer, ITextComponent title) {
        super(screenContainer);
        this.container = screenContainer;
        this.title = title;
    }

    protected abstract int sizeX();

    protected abstract int sizeY();

    protected int left() {
        return (this.field_146294_l - this.sizeX()) / 2;
    }

    protected int top() {
        return (this.field_146295_m - this.sizeY()) / 2;
    }

    public int getXSize() {
        return this.sizeX();
    }

    public int getYSize() {
        return this.sizeY();
    }

    public int getGuiLeft() {
        return this.left();
    }

    public int getGuiTop() {
        return this.top();
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
        this.font = this.field_146289_q;
    }

    protected void setDrawSlots(boolean drawSlots) {
        this.drawSlots = drawSlots;
    }

    public void func_73866_w_() {
        this.field_146999_f = this.sizeX();
        this.field_147000_g = this.sizeY();
        super.func_73866_w_();
        this.widgets.clear();
        this.tickableWidgets.clear();
        this.addWidgets();
    }

    protected abstract void addWidgets();

    protected <T extends Widget> T addWidget(T widget) {
        this.widgets.add(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.add((ITickableWidget)((Object)widget));
        }
        return widget;
    }

    protected <T extends Widget> T removeWidget(T widget) {
        this.widgets.remove(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.remove(widget);
        }
        return widget;
    }

    public void func_73876_c() {
        this.tick();
    }

    public void tick() {
        for (Widget widget : this.widgets) {
            if (!(widget instanceof ITickableWidget)) continue;
            ((ITickableWidget)((Object)widget)).tick();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.render(mouseX, mouseY, partialTicks);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179109_b((float)this.left(), (float)this.top(), (float)0.0f);
        this.renderBackground(mouseX - this.left(), mouseY - this.top());
        if (this.drawSlots) {
            for (Slot slot : ((BaseContainer)((Object)this.container)).field_75151_b) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(SLOT_TEXTURE);
                ScreenUtils.drawTexture(slot.field_75223_e - 1, slot.field_75221_f - 1, 18.0f, 18.0f);
            }
        }
        GlStateManager.func_179109_b((float)(-this.left()), (float)(-this.top()), (float)0.0f);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179141_d();
        GlStateManager.func_179140_f();
        GlStateManager.func_179109_b((float)this.left(), (float)this.top(), (float)0.0f);
        for (Widget widget : this.widgets) {
            widget.blitOffset = this.field_73735_i;
            widget.wasHovered = widget.hovered;
            widget.hovered = mouseX - this.left() > widget.x && mouseX - this.left() < widget.x + widget.width && mouseY - this.top() > widget.y && mouseY - this.top() < widget.y + widget.height;
            widget.render(mouseX - this.left(), mouseY - this.top(), partialTicks);
            widget.narrate();
        }
        this.renderForeground(mouseX - this.left(), mouseY - this.top());
        for (Widget widget : this.widgets) {
            ITextComponent text;
            if (!(widget instanceof IHoverTextWidget) || !widget.isHovered() || (text = ((IHoverTextWidget)((Object)widget)).getHoverText()) == null) continue;
            this.func_146279_a(text.func_150254_d(), mouseX - this.left(), mouseY - this.top());
        }
        GlStateManager.func_179109_b((float)(-this.left()), (float)(-this.top()), (float)0.0f);
        super.func_191948_b(mouseX, mouseY);
        this.renderTooltips(mouseX - this.left(), mouseY - this.top());
    }

    protected void func_146976_a(float partialTicks, int x, int y) {
    }

    protected void func_146979_b(int x, int y) {
    }

    protected void renderBackground(int mouseX, int mouseY) {
        this.drawScreenBackground();
    }

    protected void renderForeground(int mouseX, int mouseY) {
        ScreenUtils.drawString(this.font, this.title, 8.0f, 7.0f, 0x404040);
    }

    protected void renderTooltips(int mouseX, int mouseY) {
    }

    protected void drawScreenBackground(float x, float y, float width, float height) {
        ScreenUtils.drawScreenBackground(x, y, width, height);
    }

    protected void drawScreenBackground() {
        ScreenUtils.drawScreenBackground(0.0f, 0.0f, this.sizeX(), this.sizeY());
    }

    public boolean func_73868_f() {
        return this.isPauseScreen();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        this.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.onMousePress((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseClicked((int)mouseX, (int)mouseY, button);
        }
        mouseX += (double)this.left();
        mouseY += (double)this.top();
        try {
            super.func_73864_a((int)mouseX, (int)mouseY, button);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected void onMousePress(int mouseX, int mouseY, int button) {
    }

    protected void func_146286_b(int mouseX, int mouseY, int button) {
        this.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.onMouseRelease((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseReleased((int)mouseX, (int)mouseY, button);
        }
        super.func_146286_b((int)(mouseX += (double)this.left()), (int)(mouseY += (double)this.top()), button);
        return false;
    }

    protected void onMouseRelease(int mouseX, int mouseY, int button) {
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.left();
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.top();
        int scroll = Mouse.getEventDWheel() / 120;
        if (scroll != 0) {
            this.mouseScrolled(mouseX, mouseY, scroll);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        this.onMouseScroll((int)mouseX, (int)mouseY, delta);
        for (Widget widget : this.widgets) {
            widget.mouseScrolled((int)mouseX, (int)mouseY, delta);
        }
        return false;
    }

    protected void onMouseScroll(int mouseX, int mouseY, double scroll) {
    }

    public void func_146282_l() throws IOException {
        if (Keyboard.getEventKeyState()) {
            if (Keyboard.getEventCharacter() >= ' ') {
                super.func_146282_l();
            }
            if (!this.keyPressed(Keyboard.getEventKey())) {
                super.func_146282_l();
            }
        } else if (!this.keyReleased(Keyboard.getEventKey())) {
            super.func_146282_l();
        }
    }

    public boolean keyPressed(int keyCode) {
        boolean handled = false;
        for (Widget widget : this.widgets) {
            if (widget instanceof TextFieldWidget && ((TextFieldWidget)widget).canWrite()) {
                handled = true;
            }
            widget.keyPressed(keyCode);
        }
        if (handled) {
            return true;
        }
        if (keyCode == 1 || ClientUtils.getMinecraft().field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.closeScreen();
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode) {
        for (Widget widget : this.widgets) {
            widget.keyReleased(keyCode);
        }
        return false;
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        this.charTyped(typedChar);
    }

    public boolean charTyped(char c) {
        for (Widget widget : this.widgets) {
            widget.charTyped(c);
        }
        return false;
    }

    protected void closeScreen() {
        ClientUtils.closeScreen();
    }
}

