/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.mirror.scanner.cls;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.shadowfacts.mirror.scanner.cls.ClassScanner;

public class JarScanner
implements ClassScanner<JarScannerOptions> {
    public static final JarScanner instance = new JarScanner();

    @Override
    public Set<Class<?>> scan(JarScannerOptions options) {
        JarFile jar;
        try {
            jar = new JarFile(options.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HashSet classes = new HashSet();
        jar.stream().map(ZipEntry::getName).filter(name -> name.endsWith(".class")).map(name -> name.substring(0, name.length() - ".class".length())).map(name -> name.replace('/', '.')).map(name -> {
            try {
                return Class.forName(name, true, options.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).forEach(classes::add);
        return classes;
    }

    public static class JarScannerOptions {
        private File file;
        private ClassLoader classLoader;

        public JarScannerOptions(File file, ClassLoader classLoader) {
            this.file = file;
            this.classLoader = classLoader;
        }
    }
}

