/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.varia.SoundTools;
import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.varia.GeneralTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;

public class MineOresActionWorker
extends AbstractActionWorker {
    private AxisAlignedBB actionBox = null;

    public MineOresActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    @Override
    public AxisAlignedBB getActionBox() {
        if (this.actionBox == null) {
            this.actionBox = new AxisAlignedBB(this.options.getTargetPos().func_177982_a(-10, -5, -10), this.options.getTargetPos().func_177982_a(10, 5, 10));
        }
        return this.actionBox;
    }

    protected void harvest(BlockPos pos) {
        IMeeCreep entity = this.helper.getMeeCreep();
        World world = entity.getWorld();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        List drops = block.getDrops((IBlockAccess)world, pos, state, 0);
        ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)GeneralTools.getHarvester(world));
        SoundTools.playSound((World)world, (SoundEvent)block.func_185467_w().func_185845_c(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)1.0, (double)1.0);
        world.func_175698_g(pos);
        this.helper.giveDropsToMeeCreeps(drops);
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        if (timeToWrapUp) {
            this.helper.done();
        } else {
            this.tryFindingCropsToHarvest();
        }
    }

    protected void tryFindingCropsToHarvest() {
        IMeeCreep entity = this.helper.getMeeCreep();
        AxisAlignedBB box = this.getActionBox();
        World world = entity.getWorld();
        ArrayList positions = new ArrayList();
        GeneralTools.traverseBox(world, box, (pos, state) -> state.func_177230_c() == Blocks.field_150458_ak && this.helper.allowedToHarvest((IBlockState)state, world, (BlockPos)pos, (EntityPlayer)GeneralTools.getHarvester(world)), (pos, state) -> {
            boolean hasCrops;
            IBlockState cropState = world.func_180495_p(pos.func_177984_a());
            Block cropBlock = cropState.func_177230_c();
            boolean bl = hasCrops = cropBlock instanceof IPlantable && state.func_177230_c().canSustainPlant(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)cropBlock);
            if (hasCrops) {
                int maxAge;
                int age;
                if (cropBlock instanceof BlockCrops) {
                    int maxAge2;
                    BlockCrops crops = (BlockCrops)cropBlock;
                    int age2 = crops.func_185527_x(cropState);
                    if (age2 >= (maxAge2 = crops.func_185526_g())) {
                        positions.add(pos.func_177984_a());
                    }
                } else if (cropBlock instanceof BlockNetherWart && (age = ((Integer)cropState.func_177229_b((IProperty)BlockNetherWart.field_176486_a)).intValue()) >= (maxAge = 3)) {
                    positions.add(pos.func_177984_a());
                }
            }
        });
        if (!positions.isEmpty()) {
            BlockPos cropPos = (BlockPos)positions.get(0);
            this.helper.navigateTo(cropPos, this::harvest);
        } else if (entity.hasStuffInInventory()) {
            this.helper.putStuffAway();
        }
    }
}

