/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.actions.workers;

import mcjty.meecreeps.actions.workers.AbstractActionWorker;
import mcjty.meecreeps.api.IMeeCreep;
import mcjty.meecreeps.api.IWorkerHelper;
import mcjty.meecreeps.entities.EntityMeeCreeps;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MoveStuffActionWorker
extends AbstractActionWorker {
    public MoveStuffActionWorker(IWorkerHelper helper) {
        super(helper);
    }

    @Override
    public AxisAlignedBB getActionBox() {
        return null;
    }

    @Override
    public boolean onlyStopWhenDone() {
        return true;
    }

    @Override
    public boolean needsToFollowPlayer() {
        return true;
    }

    @Override
    public void tick(boolean timeToWrapUp) {
        IMeeCreep entity = this.helper.getMeeCreep();
        EntityMeeCreeps meeCreep = (EntityMeeCreeps)entity;
        if (timeToWrapUp) {
            meeCreep.placeDownBlock(meeCreep.func_180425_c());
            this.helper.done();
        } else {
            EntityPlayer player = this.options.getPlayer();
            if (meeCreep.getHeldBlockState() == null && player != null) {
                this.pickupBlock();
            }
            if (player == null) {
                this.helper.taskIsDone();
            } else if (player.func_130014_f_().field_73011_w.getDimension() == meeCreep.func_130014_f_().field_73011_w.getDimension()) {
                BlockPos p = this.helper.findSuitablePositionNearPlayer(4.0);
                this.helper.navigateTo(p, blockPos -> {});
            }
        }
    }

    private void pickupBlock() {
        BlockPos pos;
        EntityMeeCreeps meeCreep = (EntityMeeCreeps)this.helper.getMeeCreep();
        World world = meeCreep.getWorld();
        IBlockState state = world.func_180495_p(pos = this.options.getTargetPos());
        if (!this.helper.allowedToHarvest(state, world, pos, this.options.getPlayer())) {
            this.helper.showMessage("message.meecreeps.cant_pickup_block", new String[0]);
            this.helper.taskIsDone();
            return;
        }
        meeCreep.setHeldBlockState(state);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            NBTTagCompound tc = new NBTTagCompound();
            tileEntity.func_189515_b(tc);
            world.func_175713_t(pos);
            tc.func_82580_o("x");
            tc.func_82580_o("y");
            tc.func_82580_o("z");
            meeCreep.setCarriedNBT(tc);
        }
        world.func_175698_g(pos);
    }
}

