/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.items;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.meecreeps.MeeCreeps;
import mcjty.meecreeps.MeeCreepsApi;
import mcjty.meecreeps.actions.MeeCreepActionType;
import mcjty.meecreeps.actions.PacketShowBalloonToClient;
import mcjty.meecreeps.actions.ServerActionManager;
import mcjty.meecreeps.config.ConfigSetup;
import mcjty.meecreeps.items.ModItems;
import mcjty.meecreeps.network.MeeCreepsMessages;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class CreepCubeItem
extends Item {
    public CreepCubeItem() {
        this.setRegistryName("creepcube");
        this.func_77655_b("meecreeps.creepcube");
        this.func_77625_d(1);
        this.func_77637_a(MeeCreeps.setup.getTab());
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Collections.addAll(tooltip, StringUtils.split((String)I18n.func_135052_a((String)"message.meecreeps.tooltip.cube_intro", (Object[])new Object[0]), (String)"\n"));
        MeeCreepActionType lastAction = CreepCubeItem.getLastAction(stack);
        if (lastAction != null) {
            MeeCreepsApi.Factory factory = MeeCreeps.api.getFactory(lastAction);
            tooltip.add(TextFormatting.YELLOW + "    (" + I18n.func_135052_a((String)factory.getMessage(), (Object[])new Object[0]) + ")");
        }
        if (this.isLimited()) {
            Collections.addAll(tooltip, StringUtils.split((String)I18n.func_135052_a((String)"message.meecreeps.tooltip.cube_uses", (Object[])new Object[]{Integer.toString(ConfigSetup.meeCreepBoxMaxUsage.get() - CreepCubeItem.getUsages(stack))}), (String)"\n"));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.isLimited();
    }

    private boolean isLimited() {
        return ConfigSetup.meeCreepBoxMaxUsage.get() > 0;
    }

    public static void setLastAction(ItemStack cube, MeeCreepActionType type, @Nullable String furtherQuestionId) {
        if (cube.func_77978_p() == null) {
            cube.func_77982_d(new NBTTagCompound());
        }
        cube.func_77978_p().func_74778_a("lastType", type.getId());
        if (furtherQuestionId != null) {
            cube.func_77978_p().func_74778_a("lastQuestion", furtherQuestionId);
        }
    }

    @Nullable
    public static MeeCreepActionType getLastAction(ItemStack cube) {
        if (cube.func_77978_p() == null) {
            return null;
        }
        if (!cube.func_77978_p().func_74764_b("lastType")) {
            return null;
        }
        String lastType = cube.func_77978_p().func_74779_i("lastType");
        return new MeeCreepActionType(lastType);
    }

    @Nullable
    public static String getLastQuestionId(ItemStack cube) {
        if (cube.func_77978_p() == null) {
            return null;
        }
        if (!cube.func_77978_p().func_74764_b("lastQuestion")) {
            return null;
        }
        return cube.func_77978_p().func_74779_i("lastQuestion");
    }

    public static void setUsages(ItemStack stack, int uses) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("uses", uses);
    }

    public static int getUsages(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("uses");
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int max = ConfigSetup.meeCreepBoxMaxUsage.get();
        int usages = CreepCubeItem.getUsages(stack);
        return (double)usages / (double)max;
    }

    public static ItemStack getCube(EntityPlayer player) {
        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem.func_77973_b() != ModItems.creepCubeItem && (heldItem = player.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() != ModItems.creepCubeItem) {
            return ItemStack.field_190927_a;
        }
        return heldItem;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        int cnt;
        ItemStack heldItem;
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (this.isLimited()) {
            heldItem = player.func_184586_b(hand);
            if (CreepCubeItem.getUsages(heldItem) >= ConfigSetup.meeCreepBoxMaxUsage.get()) {
                MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.box_unusable", new String[0]), (EntityPlayerMP)player);
                return EnumActionResult.SUCCESS;
            }
            CreepCubeItem.setUsages(heldItem, CreepCubeItem.getUsages(heldItem) + 1);
        }
        if (ConfigSetup.maxMeecreepsPerPlayer.get() >= 0 && (cnt = ServerActionManager.getManager().countMeeCreeps(player)) >= ConfigSetup.maxMeecreepsPerPlayer.get()) {
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.max_spawn_reached", Integer.toString(ConfigSetup.maxMeecreepsPerPlayer.get())), (EntityPlayerMP)player);
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af()) {
            heldItem = player.func_184586_b(hand);
            MeeCreepActionType lastAction = CreepCubeItem.getLastAction(heldItem);
            if (lastAction == null) {
                MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.no_last_action", new String[0]), (EntityPlayerMP)player);
            } else {
                MeeCreepsApi.Factory factory = MeeCreeps.api.getFactory(lastAction);
                if (factory.getFactory().isPossible(world, pos, side) || factory.getFactory().isPossibleSecondary(world, pos, side)) {
                    MeeCreeps.api.spawnMeeCreep(lastAction.getId(), CreepCubeItem.getLastQuestionId(heldItem), world, pos, side, (EntityPlayerMP)player, false);
                } else {
                    MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.last_action_not_possible", new String[0]), (EntityPlayerMP)player);
                }
            }
        } else {
            ServerActionManager.getManager().createActionOptions(world, pos, side, player);
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.SUCCESS;
    }
}

