/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.teleport;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.meecreeps.items.PortalGunItem;
import mcjty.meecreeps.teleport.TeleportDestination;
import mcjty.meecreeps.teleport.TeleportationTools;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketMakePortals
implements IMessage {
    private BlockPos selectedBlock;
    private TeleportDestination destination;
    private EnumFacing selectedSide;

    public void fromBytes(ByteBuf buf) {
        this.selectedBlock = BlockPos.func_177969_a((long)buf.readLong());
        this.selectedSide = EnumFacing.field_82609_l[buf.readByte()];
        this.destination = new TeleportDestination(NetworkTools.readStringUTF8((ByteBuf)buf), buf.readInt(), BlockPos.func_177969_a((long)buf.readLong()), EnumFacing.field_82609_l[buf.readByte()]);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.selectedBlock.func_177986_g());
        buf.writeByte(this.selectedSide.ordinal());
        NetworkTools.writeStringUTF8((ByteBuf)buf, (String)this.destination.getName());
        buf.writeInt(this.destination.getDimension());
        buf.writeLong(this.destination.getPos().func_177986_g());
        buf.writeByte(this.destination.getSide().ordinal());
    }

    public PacketMakePortals() {
    }

    public PacketMakePortals(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketMakePortals(BlockPos selectedBlock, EnumFacing selectedSide, TeleportDestination destination) {
        this.selectedBlock = selectedBlock;
        this.selectedSide = selectedSide;
        this.destination = destination;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            ItemStack heldItem = PortalGunItem.getGun((EntityPlayer)player);
            if (heldItem.func_190926_b()) {
                return;
            }
            TeleportationTools.makePortalPair((EntityPlayer)player, this.selectedBlock, this.selectedSide, this.destination);
        });
        ctx.setPacketHandled(true);
    }
}

