/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.teleport;

import javax.annotation.Nullable;
import mcjty.meecreeps.actions.PacketShowBalloonToClient;
import mcjty.meecreeps.blocks.ModBlocks;
import mcjty.meecreeps.blocks.PortalTileEntity;
import mcjty.meecreeps.config.ConfigSetup;
import mcjty.meecreeps.network.MeeCreepsMessages;
import mcjty.meecreeps.teleport.TeleportDestination;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TeleportationTools {
    public static void cancelPortalPair(EntityPlayer player, BlockPos selectedBlock) {
        World sourceWorld = player.func_130014_f_();
        TileEntity te = sourceWorld.func_175625_s(selectedBlock);
        if (te instanceof PortalTileEntity) {
            PortalTileEntity source = (PortalTileEntity)te;
            source.setTimeout(10);
        }
    }

    private static boolean canPlacePortal(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    private static boolean canCollideWith(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        AxisAlignedBB box = world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos);
        return box != null;
    }

    public static void makePortalPair(EntityPlayer player, BlockPos selectedBlock, EnumFacing selectedSide, TeleportDestination dest) {
        World sourceWorld = player.func_130014_f_();
        BlockPos sourcePortalPos = TeleportationTools.findBestPosition(sourceWorld, selectedBlock, selectedSide);
        if (sourcePortalPos == null) {
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.cant_find_portal_spot", new String[0]), (EntityPlayerMP)player);
            return;
        }
        World destWorld = mcjty.lib.varia.TeleportationTools.getWorldForDimension((int)dest.getDimension());
        if (destWorld.func_180495_p(dest.getPos()).func_177230_c() == ModBlocks.portalBlock) {
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.portal_already_there", new String[0]), (EntityPlayerMP)player);
            return;
        }
        if (dest.getSide() == EnumFacing.DOWN) {
            if (!TeleportationTools.canPlacePortal(destWorld, dest.getPos()) || TeleportationTools.canCollideWith(destWorld, dest.getPos().func_177977_b())) {
                MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.destination_obstructed", new String[0]), (EntityPlayerMP)player);
                return;
            }
        } else if (!TeleportationTools.canPlacePortal(destWorld, dest.getPos()) || TeleportationTools.canCollideWith(destWorld, dest.getPos().func_177984_a())) {
            MeeCreepsMessages.INSTANCE.sendTo((IMessage)new PacketShowBalloonToClient("message.meecreeps.destination_obstructed", new String[0]), (EntityPlayerMP)player);
            return;
        }
        sourceWorld.func_180501_a(sourcePortalPos, ModBlocks.portalBlock.func_176223_P(), 3);
        PortalTileEntity source = (PortalTileEntity)sourceWorld.func_175625_s(sourcePortalPos);
        destWorld.func_180501_a(dest.getPos(), ModBlocks.portalBlock.func_176223_P(), 3);
        PortalTileEntity destination = (PortalTileEntity)destWorld.func_175625_s(dest.getPos());
        source.setTimeout(ConfigSetup.portalTimeout.get());
        source.setOther(dest);
        source.setPortalSide(selectedSide);
        destination.setTimeout(ConfigSetup.portalTimeout.get());
        destination.setOther(new TeleportDestination("", sourceWorld.field_73011_w.getDimension(), sourcePortalPos, selectedSide));
        destination.setPortalSide(dest.getSide());
    }

    public static void makePortalPair(World sourceWorld, BlockPos selectedBlock, EnumFacing selectedSide, TeleportDestination dest) {
        BlockPos sourcePortalPos = TeleportationTools.findBestPosition(sourceWorld, selectedBlock, selectedSide);
        if (sourcePortalPos == null) {
            return;
        }
        World destWorld = mcjty.lib.varia.TeleportationTools.getWorldForDimension((int)dest.getDimension());
        if (destWorld.func_180495_p(dest.getPos()).func_177230_c() == ModBlocks.portalBlock) {
            return;
        }
        if (dest.getSide() == EnumFacing.DOWN ? !destWorld.func_175623_d(dest.getPos()) || !destWorld.func_175623_d(dest.getPos().func_177977_b()) : !destWorld.func_175623_d(dest.getPos()) || !destWorld.func_175623_d(dest.getPos().func_177984_a())) {
            return;
        }
        sourceWorld.func_180501_a(sourcePortalPos, ModBlocks.portalBlock.func_176223_P(), 3);
        PortalTileEntity source = (PortalTileEntity)sourceWorld.func_175625_s(sourcePortalPos);
        destWorld.func_180501_a(dest.getPos(), ModBlocks.portalBlock.func_176223_P(), 3);
        PortalTileEntity destination = (PortalTileEntity)destWorld.func_175625_s(dest.getPos());
        source.setTimeout(ConfigSetup.portalTimeout.get());
        source.setOther(dest);
        source.setPortalSide(selectedSide);
        destination.setTimeout(ConfigSetup.portalTimeout.get());
        destination.setOther(new TeleportDestination("", sourceWorld.field_73011_w.getDimension(), sourcePortalPos, selectedSide));
        destination.setPortalSide(dest.getSide());
    }

    @Nullable
    public static BlockPos findBestPosition(World world, BlockPos selectedBlock, EnumFacing selectedSide) {
        if (selectedSide == EnumFacing.UP) {
            if (world.func_175623_d(selectedBlock.func_177984_a()) && world.func_175623_d(selectedBlock.func_177981_b(2))) {
                return selectedBlock.func_177984_a();
            }
            return null;
        }
        if (selectedSide == EnumFacing.DOWN) {
            if (world.func_175623_d(selectedBlock.func_177977_b()) && world.func_175623_d(selectedBlock.func_177979_c(2))) {
                return selectedBlock.func_177977_b();
            }
            return null;
        }
        if (world.func_175623_d((selectedBlock = selectedBlock.func_177972_a(selectedSide)).func_177977_b())) {
            selectedBlock = selectedBlock.func_177977_b();
        }
        if (!world.func_175623_d(selectedBlock.func_177977_b())) {
            return TeleportationTools.findBestPosition(world, selectedBlock.func_177977_b(), EnumFacing.UP);
        }
        return null;
    }
}

