/*
 * Decompiled with CFR 0.152.
 */
package mcjty.meecreeps.varia;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class GeneralTools {
    private static FakePlayer harvester = null;

    public static FakePlayer getHarvester(World world) {
        if (harvester == null) {
            harvester = FakePlayerFactory.get((WorldServer)DimensionManager.getWorld((int)0), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("meecreeps".getBytes()), "meecreeps"));
        }
        harvester.func_70029_a(world);
        harvester.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151046_w));
        return harvester;
    }

    public static boolean traverseBoxTest(AxisAlignedBB box, Predicate<BlockPos> matcher) {
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (matcher.test(pos)) {
                        return true;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    @Nullable
    public static <T> T traverseBoxFirst(AxisAlignedBB box, Function<BlockPos, T> matcher) {
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    BlockPos pos = new BlockPos(x, y, z);
                    T result = matcher.apply(pos);
                    if (result != null) {
                        return result;
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return null;
    }

    public static void traverseBoxConsume(AxisAlignedBB box, Consumer<BlockPos> consumer) {
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    BlockPos pos = new BlockPos(x, y, z);
                    consumer.accept(pos);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static void traverseBox(World world, AxisAlignedBB box, BiPredicate<BlockPos, IBlockState> tester, BiConsumer<BlockPos, IBlockState> consumer) {
        int x = (int)box.field_72340_a;
        while ((double)x <= box.field_72336_d) {
            int y = (int)box.field_72338_b;
            while ((double)y <= box.field_72337_e) {
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = world.func_180495_p(pos);
                    if (tester.test(pos, state)) {
                        consumer.accept(pos, state);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }
}

