/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiHelmetMainOptions;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiHelmetMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.common.config.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MainHelmetHandler
implements IUpgradeRenderHandler {
    private GuiAnimatedStat powerStat;
    public GuiAnimatedStat testMessageStat;

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getUpgradeName() {
        return "coreComponents";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void update(EntityPlayer player, int rangeUpgrades) {
        List<String> l = Arrays.stream(UpgradeRenderHandlerList.ARMOR_SLOTS).map(slot -> this.getPressureStr(player, (EntityEquipmentSlot)slot)).collect(Collectors.toList());
        this.powerStat.setText(l);
    }

    private String getPressureStr(EntityPlayer player, EntityEquipmentSlot slot) {
        if (!ItemPneumaticArmor.isPneumaticArmorPiece(player, slot)) {
            return "-";
        }
        float pressure = CommonArmorHandler.getHandlerForPlayer((EntityPlayer)player).armorPressure[slot.func_188454_b()];
        TextFormatting colour = pressure < 0.5f ? TextFormatting.RED : (pressure < 2.0f ? TextFormatting.GOLD : (pressure < 4.0f ? TextFormatting.YELLOW : TextFormatting.GREEN));
        return colour.toString() + String.format("%5.2f", Float.valueOf(pressure));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render3D(float partialTicks) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render2D(float partialTicks, boolean helmetEnabled) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.powerStat == null) {
            this.powerStat = new GuiAnimatedStat(null, "", GuiAnimatedStat.StatIcon.NONE, 0x3000AA00, null, ArmorHUDLayout.INSTANCE.powerStat);
            this.powerStat.setLineSpacing(15);
            this.powerStat.setWidgetOffsets(-18, 0);
            for (EntityEquipmentSlot slot : UpgradeRenderHandlerList.ARMOR_SLOTS) {
                GuiButtonSpecial pressureButton = new GuiButtonSpecial(-1, 0, 5 + (3 - slot.func_188454_b()) * 15, 18, 18, "");
                ItemStack stack = GuiHelmetMainScreen.ARMOR_STACKS[slot.func_188454_b()];
                pressureButton.setVisible(false);
                pressureButton.setRenderStacks(stack);
                this.powerStat.addWidget(pressureButton);
            }
            this.powerStat.setMinDimensionsAndReset(0, 0);
            this.powerStat.openWindow();
        }
        return this.powerStat;
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[0];
    }

    @Override
    public float getEnergyUsage(int rangeUpgrades, EntityPlayer player) {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void reset() {
        this.powerStat = null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IOptionPage getGuiOptionsPage() {
        return new GuiHelmetMainOptions(this);
    }

    @Override
    public float getMinimumPressure() {
        return -1.0f;
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.HEAD;
    }

    @Override
    public void onResolutionChanged() {
        this.powerStat = null;
    }
}

