/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.biome;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.rwtema.extrautils2.RunnableClient;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.network.XUPacketServerToClient;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;

public class BiomeManip {
    public static final Map<BiomeDictionary.Type, ItemRef> types = ImmutableMap.builder().put((Object)BiomeDictionary.Type.END, (Object)ItemRef.wrap(Items.field_151079_bi)).put((Object)BiomeDictionary.Type.NETHER, (Object)ItemRef.wrap(Items.field_151075_bm)).build();

    public static void setMultiBiome(World world, Biome biome, BlockPos ... poses) {
        byte id = (byte)Biome.func_185362_a((Biome)biome);
        HashMultimap changes = HashMultimap.create();
        for (BlockPos pos : poses) {
            changes.put((Object)new ChunkPos(pos), (Object)pos);
        }
        for (ChunkPos chunkPos : changes.keySet()) {
            Chunk chunk = world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
            byte[] biomeArray = chunk.func_76605_m();
            Set changeSet = changes.get((Object)chunkPos);
            Iterator iterator = changeSet.iterator();
            while (iterator.hasNext()) {
                BlockPos pos = (BlockPos)iterator.next();
                int i = pos.func_177958_n() & 0xF;
                int j = pos.func_177952_p() & 0xF;
                if (biomeArray[j << 4 | i] == id) {
                    iterator.remove();
                    continue;
                }
                biomeArray[j << 4 | i] = id;
            }
        }
        if (world instanceof WorldServer) {
            PlayerChunkMap playerChunkMap = ((WorldServer)world).func_184164_w();
            for (ChunkPos chunkPos : changes.keySet()) {
                PlayerChunkMapEntry entry2;
                Set changeSet = changes.get((Object)chunkPos);
                if (changeSet.isEmpty() || (entry2 = playerChunkMap.func_187301_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) == null) continue;
                entry2.func_187267_a(NetworkHandler.channels.get(Side.SERVER).generatePacketFrom((Object)new PacketBiomeChange(biome, changeSet.toArray(new BlockPos[0]))));
            }
        }
    }

    public static void setBiome(World world, Biome biome, BlockPos pos) {
        int chunkZ;
        int chunkX;
        PlayerChunkMap playerChunkMap;
        PlayerChunkMapEntry entry2;
        Chunk chunk = world.func_175726_f(pos);
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177952_p() & 0xF;
        byte id = (byte)Biome.func_185362_a((Biome)biome);
        byte b = chunk.func_76605_m()[j << 4 | i];
        if (b == id) {
            return;
        }
        chunk.func_76605_m()[j << 4 | i] = id;
        chunk.func_76630_e();
        if (world instanceof WorldServer && (entry2 = (playerChunkMap = ((WorldServer)world).func_184164_w()).func_187301_b(chunkX = pos.func_177958_n() >> 4, chunkZ = pos.func_177952_p() >> 4)) != null) {
            entry2.func_187267_a(NetworkHandler.channels.get(Side.SERVER).generatePacketFrom((Object)new PacketBiomeChange(world, pos)));
        }
    }

    @NetworkHandler.XUPacket
    public static class PacketBiomeChange
    extends XUPacketServerToClient {
        BlockPos[] positions;
        Biome biome;

        public PacketBiomeChange(World world, BlockPos pos) {
            this(world.getBiomeForCoordsBody(pos), pos);
        }

        public PacketBiomeChange(Biome biome, BlockPos ... positions) {
            this.positions = positions;
            this.biome = biome;
        }

        public PacketBiomeChange() {
        }

        @Override
        public void writeData() throws Exception {
            this.writeByte(Biome.func_185362_a((Biome)this.biome));
            this.writeShort(this.positions.length);
            for (BlockPos position : this.positions) {
                this.writeBlockPos(position);
            }
        }

        @Override
        public void readData(EntityPlayer player) {
            this.biome = Biome.func_150568_d((int)this.readUnsignedByte());
            int len = this.readShort();
            this.positions = new BlockPos[len];
            for (int i = 0; i < len; ++i) {
                this.positions[i] = this.readBlockPos();
            }
        }

        @Override
        public Runnable doStuffClient() {
            return new RunnableClient(){

                @Override
                public void run() {
                    WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
                    BiomeManip.setMultiBiome((World)theWorld, biome, positions);
                    HashSet<ChunkPos> finishedPos = new HashSet<ChunkPos>();
                    for (BlockPos pos : positions) {
                        if (!finishedPos.add(new ChunkPos(pos))) continue;
                        int chunkX = pos.func_177958_n() >> 4;
                        int chunkZ = pos.func_177952_p() >> 4;
                        theWorld.func_147458_c(chunkX << 4, 0, chunkZ << 4, (chunkX << 4) + 15, 256, (chunkZ << 4) + 15);
                    }
                }
            };
        }
    }
}

