/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import java.util.WeakHashMap;

public abstract class ClassCache<T> {
    WeakHashMap<Class, T> values = new WeakHashMap();

    public T getFromObject(Object object) {
        if (object == null) {
            return this.nullObjectValue();
        }
        return this.getClass(object.getClass());
    }

    public T getClass(Class clazz) {
        if (clazz == null) {
            return this.nullClassValue();
        }
        if (this.values.containsKey(clazz)) {
            return this.values.get(clazz);
        }
        T t = this.calc(clazz);
        this.values.put(clazz, t);
        return t;
    }

    public void clear() {
        this.values.clear();
    }

    protected abstract T calc(Class var1);

    protected T nullClassValue() {
        throw new NullPointerException();
    }

    protected T nullObjectValue() {
        throw new NullPointerException();
    }
}

