/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.client.model;

import com.vladmarica.energymeters.block.BlockEnergyMeter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class TextureLocations {
    private static final Map<BlockEnergyMeter.MeterType, ResourceLocation> SIDE_TEXTURES = new HashMap<BlockEnergyMeter.MeterType, ResourceLocation>();
    private static final Map<BlockEnergyMeter.MeterType, ResourceLocation> INPUT_TEXTURES = new HashMap<BlockEnergyMeter.MeterType, ResourceLocation>();
    private static final Map<BlockEnergyMeter.MeterType, ResourceLocation> OUTPUT_TEXTURES = new HashMap<BlockEnergyMeter.MeterType, ResourceLocation>();
    private static final Map<BlockEnergyMeter.MeterType, ResourceLocation> SCREEN_TEXTURES = new HashMap<BlockEnergyMeter.MeterType, ResourceLocation>();

    public static ResourceLocation getSideTexture(BlockEnergyMeter.MeterType type) {
        return SIDE_TEXTURES.get((Object)type);
    }

    public static ResourceLocation getInputTexture(BlockEnergyMeter.MeterType type) {
        return INPUT_TEXTURES.get((Object)type);
    }

    public static ResourceLocation getOutputTexture(BlockEnergyMeter.MeterType type) {
        return OUTPUT_TEXTURES.get((Object)type);
    }

    public static ResourceLocation getScreenTexture(BlockEnergyMeter.MeterType type) {
        return SCREEN_TEXTURES.get((Object)type);
    }

    public static ResourceLocation getGuiResource(ResourceLocation location) {
        String path = location.func_110623_a();
        return new ResourceLocation(location.func_110624_b(), String.format("textures/%s.png", path));
    }

    static {
        for (BlockEnergyMeter.MeterType meterType : BlockEnergyMeter.MeterType.values()) {
            String suffix = meterType != BlockEnergyMeter.MeterType.FE_METER ? "_" + meterType.func_176610_l() : "";
            SIDE_TEXTURES.put(meterType, new ResourceLocation("energymeters", "blocks/meter" + suffix));
            INPUT_TEXTURES.put(meterType, new ResourceLocation("energymeters", "blocks/meter_input" + suffix));
            OUTPUT_TEXTURES.put(meterType, new ResourceLocation("energymeters", "blocks/meter_output" + suffix));
            SCREEN_TEXTURES.put(meterType, new ResourceLocation("energymeters", "blocks/meter_screen" + suffix));
        }
    }
}

