/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.energy.storage;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import com.vladmarica.energymeters.energy.IEnergyMeter;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;

public class MJStorage
implements IMjReceiver {
    private IEnergyMeter meter;
    private EnumFacing side;
    private boolean connectToReceiversOnly;

    public MJStorage(IEnergyMeter meter, EnumFacing side, boolean connectToReceiversOnly) {
        this.meter = meter;
        this.side = side;
        this.connectToReceiversOnly = connectToReceiversOnly;
    }

    public long getPowerRequested() {
        return this.meter.getRequestedEnergy(this.side);
    }

    public long receivePower(long microJoules, boolean simulate) {
        return microJoules - this.meter.receiveEnergy(microJoules, simulate, this.side);
    }

    public boolean canConnect(@Nonnull IMjConnector other) {
        if (other instanceof MJStorage) {
            return false;
        }
        if (this.connectToReceiversOnly) {
            return other instanceof IMjReceiver && ((IMjReceiver)other).canReceive();
        }
        return true;
    }
}

