/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.energymeters.integration;

import com.vladmarica.energymeters.EnergyMetersMod;
import com.vladmarica.energymeters.tile.TileEntityEnergyMeterBase;
import dan200.computercraft.api.lua.ArgumentHelper;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(modid="computercraft", iface="dan200.computercraft.api.peripheral.IPeripheral")
public class ComputerComponent
implements IPeripheral {
    public static final String COMPONENT_NAME = "energy_meter";
    private TileEntityEnergyMeterBase meter;

    public ComputerComponent(TileEntityEnergyMeterBase meter) {
        this.meter = meter;
    }

    public Object[] getTransferRate() {
        return new Object[]{Float.valueOf(this.meter.getTransferRate() / (float)this.meter.getEnergyScale())};
    }

    public Object[] getTotalEnergyTransferred() {
        return new Object[]{this.meter.getTotalEnergyTransferred() / (long)this.meter.getEnergyScale()};
    }

    public Object[] getStatus() {
        String statusString = "active";
        if (!this.meter.isFullyConnected()) {
            statusString = "not connected";
        } else if (this.meter.isDisabled()) {
            statusString = "disabled";
        }
        return new Object[]{statusString};
    }

    public Object[] getRedstoneControlState() {
        return new Object[]{this.meter.getRedstoneControlState().getDescription().toLowerCase()};
    }

    public Object[] getEnergyType() {
        return new Object[]{this.meter.getEnergyType().getName()};
    }

    public Object[] getEnergyTypeAlias() {
        return new Object[]{this.meter.getEnergyAlias().getDisplayName()};
    }

    public Object[] getTransferRateLimit() {
        return new Object[]{this.meter.getRateLimit()};
    }

    public Object[] setTransferRateLimit(int limit) {
        boolean rateValid;
        if (!this.meter.getEnergyType().isLimitable()) {
            return new Object[]{false};
        }
        boolean bl = rateValid = limit >= 0 || limit == -1;
        if (rateValid) {
            this.meter.handleRateLimitChangeRequest(limit);
        }
        return new Object[]{rateValid};
    }

    @Optional.Method(modid="computercraft")
    @Nonnull
    public String getType() {
        return COMPONENT_NAME;
    }

    @Optional.Method(modid="computercraft")
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"getTransferRate", "getTotalEnergyTransferred", "getStatus", "getRedstoneControlState", "getEnergyType", "getEnergyTypeAlias", "getTransferRateLimit", "setTransferRateLimit"};
    }

    @Optional.Method(modid="computercraft")
    @Nullable
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return this.getTransferRate();
            }
            case 1: {
                return this.getTotalEnergyTransferred();
            }
            case 2: {
                return this.getStatus();
            }
            case 3: {
                return this.getRedstoneControlState();
            }
            case 4: {
                return this.getEnergyType();
            }
            case 5: {
                return this.getEnergyTypeAlias();
            }
            case 6: {
                return this.getTransferRateLimit();
            }
            case 7: {
                return this.setTransferRateLimit(ArgumentHelper.getInt((Object[])args, (int)0));
            }
        }
        EnergyMetersMod.LOGGER.error("Attempted to call unknownComputerCraft method {}", (Object)method);
        return null;
    }

    @Optional.Method(modid="computercraft")
    public boolean equals(@Nullable IPeripheral other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ComputerComponent) {
            ComputerComponent otherComponent = (ComputerComponent)other;
            return this.meter.func_174877_v().equals((Object)otherComponent.meter.func_174877_v()) && this.meter.func_145831_w().field_73011_w.getDimension() == otherComponent.meter.func_145831_w().field_73011_w.getDimension();
        }
        return false;
    }
}

